/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class GameCanvas
extends Canvas
implements Runnable {
    static final byte INGAMEMODE_GAMEOVER = 6;
    static final byte INGAMEMODE_INIT = 1;
    static final byte INGAMEMODE_NOTHING = 0;
    static final byte INGAMEMODE_PAUSED = 4;
    static final byte INGAMEMODE_RESTART = 5;
    static final byte INGAMEMODE_RUNNING = 3;
    static final byte INGAMEMODE_START = 2;
    static final byte INGAMEMODE_TUTORIAL = 7;
    static final byte LNG_DUTCH = 5;
    static final byte LNG_ENGLISH = 0;
    static final byte LNG_FRENCH = 2;
    static final byte LNG_GERMAN = 1;
    static final byte LNG_ITALIAN = 4;
    static final byte LNG_SPANISH = 3;
    static final byte LOAD_GAME = 5;
    static final byte LOAD_INIT = 0;
    static final byte LOAD_INTRO = 3;
    static final byte LOAD_MENU = 4;
    static final byte LOAD_NON = 1;
    static final byte LOAD_STATIC = 2;
    static final int ML_BIT_LISTINDENT = 0x400000;
    static final int ML_BIT_OPTIONALWRAP = 0x200000;
    static final int ML_BIT_SHADOWED = 0x100000;
    static final int ML_CAPACITYINCREMENT = 6;
    static final int ML_CAPACITYTHRESHOLD = 3;
    static final int[] ML_COLOR_TABLE;
    static final char ML_EOP = '^';
    static final char ML_EOPI = '|';
    static final char ML_LISTCHAR = '-';
    static final int ML_LISTINDENT = 9;
    static final int ML_MASK_ANCHOR = 61440;
    static final int ML_MASK_ANCHOR_SHIFT = 12;
    static final int ML_MASK_BCOLOR = 15;
    static final int ML_MASK_FCOLOR = 240;
    static final int ML_MASK_FCOLOR_SHIFT = 4;
    static final int ML_MASK_FLAGS = 0xF00000;
    static final int ML_MASK_FONT = 3840;
    static final int ML_MASK_FONT_SHIFT = 8;
    static final int ML_MASK_NEWLINE = 0x10000000;
    static final char ML_OWRAP = '_';
    static final int ML_SCROLLBAR_TEXT_GAP = 3;
    static final int ML_SCROLLBAR_WIDTH = 5;
    static final char ML_WRAP = '-';
    static final char[] ML_WRAPCHARS;
    static final byte MODE_ERROR = 0;
    static final byte MODE_HELP = 6;
    static final byte MODE_HIGHSCORE = 9;
    static final byte MODE_INFO = 7;
    static final byte MODE_INGAME = 5;
    static final byte MODE_INIT = 1;
    static final byte MODE_INPUT = 8;
    static final byte MODE_INTRO = 2;
    static final byte MODE_LANGUAGE = 3;
    static final byte MODE_MAINMENU = 4;
    private static final int PLAYER_LOOK_LEFT = 1;
    private static final int PLAYER_LOOK_PICKUP = 3;
    private static final int PLAYER_LOOK_RIGHT = 2;
    private static final int SCORE_PER_BONUS = 100;
    private static final int SCORE_PER_GAME_COMPLETED = 2000;
    private static final int SCORE_PER_PICKED_UP_ITEM = 5;
    private static final int SCORE_PER_REST_SECOND = 2;
    private static final int SCORE_PER_THROWN_ITEM = 10;
    static final byte SOUND_BONUS = 6;
    static final byte SOUND_COMPLETE = 2;
    static final byte SOUND_LEVELUP = 5;
    static final byte SOUND_MUSIC = 0;
    static final byte SOUND_PICKUP = 4;
    static final byte SOUND_THROW = 3;
    static final byte SOUND_TIMEOUT = 1;
    long T;
    private static final int TIME_ITEM_SINK = 131060;
    private static final int TIME_ITEM_START_SINK = 196590;
    private static final int TIME_ITEM_SUNK = 327650;
    private static final int TIME_ITEM_TO_ITEM_CREATE = 65530;
    private static final int TIME_PER_LEVEL = 3931800;
    private static final int TIME_SCORE_MULTIPLICATOR = 655300;
    long U;
    CBitmapFont m_BitmapFont1;
    CBitmapFont m_BitmapFont2;
    CBitmapFont m_BitmapFont3;
    Font m_Font;
    CHighscore m_Highscore;
    CMenu m_LngMenu;
    CMenu m_Menu;
    CRecordHandler m_RecordHandler;
    CSoundsManager m_SndMan;
    CStringInput m_StringInput;
    int[][] m_aClouds;
    int[] m_anMLBlocks;
    int[] m_anMLLines;
    String[] m_astrLang;
    boolean m_bKeyDown;
    boolean m_bKeyLeft;
    boolean m_bKeyRight;
    boolean m_bKeyUp;
    boolean m_bNoUpdate = true;
    byte m_byIngameMode = 0;
    byte m_byLanguage = 0;
    byte m_byLoading = 0;
    byte m_byMode = 1;
    byte m_byNewLanguage = 0;
    byte m_bySoundMode;
    byte m_byTutorial = 1;
    static final byte m_byVersion = 11;
    int m_iAutoScrollClouds = 0;
    private int m_iBackgroundPosX = 0;
    private int m_iBackgroundPosY = 0;
    private int m_iBackgroundWidth = 0;
    private int m_iBonusCatchedCount = 0;
    private int m_iBonusPosX = -10;
    private int m_iBonusPosY = 0;
    public static final int[][] m_iFirePos;
    int m_iHighscoreHighlight;
    int m_iIngameModeCount = 0;
    private int m_iItemsLevel = 0;
    private int m_iItemsToDeliverLevel = 0;
    int m_iLastScore;
    private int m_iLevel = 0;
    int m_iMLmaxHeigth;
    int m_iMLmaxLineWidth;
    private int m_iMaxItems = 0;
    int m_iModeCount = 0;
    private int m_iMultiplicatorScore = 1;
    private int m_iOneLayerHousesX = 0;
    private int m_iPlayerAniFrame = 0;
    private int m_iPlayerMode = 0;
    private int m_iPlayerPosX = 0;
    private int m_iPlayerPosY = 0;
    int m_iScore;
    public static final int[][] m_iStorePos;
    int m_iTextScroll;
    static final int m_iTick = 6553;
    private Image m_imBack = null;
    private Image m_imBackground = null;
    Image m_imBitmapFont1;
    Image m_imBitmapFont2;
    Image m_imBitmapFont3;
    private Image m_imHUD = null;
    Image m_imIntro = null;
    private Image m_imNext = null;
    private Image m_imSky = null;
    Image m_imTitle;
    Image m_imTitleDark;
    private long m_lBonusStartTime = 0L;
    private long m_lEndScoreMultiplicatorTime = 0L;
    long m_lIngameModeTime = 0L;
    private long m_lLastItemCreateTime = 0L;
    private long m_lLevelEndTime = 0L;
    private long m_lLevelTime = 0L;
    long m_lModeTime = 0L;
    private long m_lStartScoreAddTime = 0L;
    private long m_lTime = 0L;
    CMO m_moFire1 = null;
    CMO m_moFire2 = null;
    CMO m_moFire3 = null;
    CMO m_moFire4 = null;
    CMO m_moItem1 = null;
    CMO m_moItem2 = null;
    CMO m_moItem3 = null;
    CMO m_moItem4 = null;
    CMO m_moItem5 = null;
    int m_nMLBegin = 0;
    int m_nMLBlockInfo = 0;
    int m_nMLEnd = 0;
    private Random m_random;
    String m_sMlt;
    CSprite m_spBonus = null;
    CSprite m_spCloud = null;
    CSprite m_spFire1 = null;
    CSprite m_spFire2 = null;
    CSprite m_spFire3 = null;
    CSprite m_spFire4 = null;
    CSprite m_spItem1 = null;
    CSprite m_spItem2 = null;
    CSprite m_spItem3 = null;
    CSprite m_spItem4 = null;
    CSprite m_spItem5 = null;
    CSprite m_spPlayer = null;
    String m_strLeftSoftKey = "";
    String m_strMLCache;
    String m_strRightSoftKey = "";
    private Vector m_vCarryItems;
    private Vector m_vDeliverItems;
    Vector m_vEventQueue = new Vector(10, 2);
    private Vector m_vFreeIDs;
    private Vector m_vItems;
    private Vector m_vScore;
    Vector m_vSoundNames;
    final GameMIDlet parent;

    static {
        m_iStorePos = new int[][]{{50, 72}, {147, 75}, {284, 73}, {362, 71}};
        m_iFirePos = new int[][]{{34, 54}, {131, 58}, {268, 56}, {346, 54}};
        ML_WRAPCHARS = new char[]{' ', '-', '/'};
        ML_COLOR_TABLE = new int[]{0, 9020842, 0xFFFF00, 0xFFFF7F, 16436618};
    }

    GameCanvas(GameMIDlet parent) {
        this.m_astrLang = new String[0];
        this.m_vSoundNames = new Vector();
        this.m_bySoundMode = (byte)2;
        this.m_Font = Font.getDefaultFont();
        this.m_aClouds = new int[3][4];
        this.m_anMLBlocks = new int[122];
        this.m_anMLLines = new int[40];
        this.parent = parent;
        this.setFullScreenMode(true);
        this.m_Highscore = new CHighscore(this, 9, 8, this.m_Font, -1);
        this.m_Highscore.setClipRect(5, 25, 166, 163);
        int[] temp = new int[]{-1, 8, 112};
        this.m_Highscore.setColumnOffset(temp);
        int i = 0;
        String strTemp = "";
        i = 0;
        while (i < 8) {
            strTemp = strTemp + "-";
            ++i;
        }
        i = 0;
        while (i < 9) {
            this.m_Highscore.addHighscore(strTemp, i * 100);
            ++i;
        }
        try {
            this.m_imIntro = Image.createImage((String)"/pix/intro.png");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_RecordHandler = new CRecordHandler("Bubbles");
        this.loadRecordData();
        this.LoadLanguage();
        this.m_bNoUpdate = true;
    }

    private void DrawItemList(Graphics g, Vector vItem) {
        Enumeration e = vItem.elements();
        while (e.hasMoreElements()) {
            CItem cItemLocal = (CItem)e.nextElement();
            this.m_spItem1.iX = this.m_iBackgroundPosX + cItemLocal.iX - (this.m_spItem1.m_nFrameWidth >> 1);
            if (this.m_spItem1.iX < -this.m_spItem1.m_nFrameWidth || this.m_spItem1.iX >= 176 + (this.m_spItem1.m_nFrameWidth >> 1)) continue;
            this.m_spItem1.iY = this.m_iBackgroundPosY + cItemLocal.iY;
            this.m_spItem1.iY += cItemLocal.iSunk;
            if (cItemLocal.iColor == 0) {
                this.m_spItem1.iX = this.m_spItem1.iX;
                this.m_spItem1.iY = this.m_spItem1.iY;
                this.m_spItem1.draw(g);
            }
            if (cItemLocal.iColor == 1) {
                this.m_spItem2.iX = this.m_spItem1.iX;
                this.m_spItem2.iY = this.m_spItem1.iY;
                this.m_spItem2.draw(g);
            }
            if (cItemLocal.iColor == 2) {
                this.m_spItem3.iX = this.m_spItem1.iX;
                this.m_spItem3.iY = this.m_spItem1.iY;
                this.m_spItem3.draw(g);
            }
            if (cItemLocal.iColor == 3) {
                this.m_spItem4.iX = this.m_spItem1.iX;
                this.m_spItem4.iY = this.m_spItem1.iY;
                this.m_spItem4.draw(g);
            }
            if (cItemLocal.iColor < 4) continue;
            this.m_spItem5.iX = this.m_spItem1.iX;
            this.m_spItem5.iY = this.m_spItem1.iY;
            this.m_spItem5.draw(g);
        }
    }

    final void Init() {
        try {
            this.m_imBitmapFont1 = Image.createImage((String)"/font/font1.png");
        }
        catch (IOException e) {
            // empty catch block
        }
        this.m_BitmapFont1 = new CBitmapFont(this.m_imBitmapFont1, "/font/font.dat", "\"!#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00df[\\]^_`abcdefghijklmnopqrstuvwxyz{}~\u00a9\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u0105\u00e1\u00e0\u00e2\u00e3\u00e7\u010d\u0107\u010c\u00c7\u00e9\u00e8\u00ea\u011b\u0119\u010f|\u0142\u00a1\u00ed\u00ec\u0130\u0131\u00f1\u00f3\u00f5\u0159\u015b\u0161\u015f\u00fa\u00f9\u016f\u00fd\u017e\u017c\u011f\u00c1\u00f4", 5);
        try {
            this.m_imBitmapFont2 = Image.createImage((String)"/font/font2.png");
        }
        catch (IOException e) {
            // empty catch block
        }
        this.m_BitmapFont2 = new CBitmapFont(this.m_imBitmapFont2, "/font/font.dat", "\"!#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00df[\\]^_`abcdefghijklmnopqrstuvwxyz{}~\u00a9\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u0105\u00e1\u00e0\u00e2\u00e3\u00e7\u010d\u0107\u010c\u00c7\u00e9\u00e8\u00ea\u011b\u0119\u010f|\u0142\u00a1\u00ed\u00ec\u0130\u0131\u00f1\u00f3\u00f5\u0159\u015b\u0161\u015f\u00fa\u00f9\u016f\u00fd\u017e\u017c\u011f\u00c1\u00f4", 5);
        try {
            this.m_imBitmapFont3 = Image.createImage((String)"/font/numbers.png");
        }
        catch (IOException e) {
            // empty catch block
        }
        this.m_BitmapFont3 = new CBitmapFont(this.m_imBitmapFont3, "/font/numbers.dat", "/0123456789Lev.+x", 4);
        this.m_SndMan = new CSoundsManager(-1, 7);
        this.m_StringInput = new CStringInput(this, 8);
        this.m_LngMenu = new CMenu(this);
        CMenuItem itemLM = this.m_LngMenu.m_itemRoot;
        itemLM.m_strName = this.m_astrLang[27];
        itemLM.AddMenuItem(0, 100, "English");
        itemLM.AddMenuItem(1, 100, "Deutsch");
        itemLM.AddMenuItem(2, 100, "Fran\u00e7ais");
        itemLM.AddMenuItem(3, 100, "Espa\u00f1ol");
        itemLM.AddMenuItem(4, 100, "Italiano");
        itemLM.AddMenuItem(5, 100, "Nederlands");
        this.m_LngMenu.m_itemCurrent = (CMenuItem)itemLM.m_vMenuItems.elementAt(this.m_byLanguage);
        this.m_random = new Random();
        this.m_vItems = new Vector();
        this.m_vCarryItems = new Vector();
        this.m_vDeliverItems = new Vector();
        this.m_vFreeIDs = new Vector();
        this.m_vScore = new Vector();
        this.Load(2);
        this.Load(3);
        this.Load(4);
        this.Load(5);
    }

    public void Load(int iLoadMode) {
        try {
            switch (iLoadMode) {
                case 2: {
                    this.m_SndMan.loadSound((byte)0, "/sfx/music.mid", "audio/midi", (byte)2);
                    this.m_SndMan.loadSound((byte)1, "/sfx/timeout.amr", "audio/amr", (byte)1);
                    this.m_SndMan.loadSound((byte)2, "/sfx/complete.amr", "audio/amr", (byte)1);
                    this.m_SndMan.loadSound((byte)3, "/sfx/throw.amr", "audio/amr", (byte)1);
                    this.m_SndMan.loadSound((byte)4, "/sfx/pickup.amr", "audio/amr", (byte)1);
                    this.m_SndMan.loadSound((byte)5, "/sfx/levelup.amr", "audio/amr", (byte)1);
                    this.m_SndMan.loadSound((byte)6, "/sfx/bonus.amr", "audio/amr", (byte)1);
                    this.m_imBack = Image.createImage((String)"/icons/back.png");
                    this.m_imNext = Image.createImage((String)"/icons/next.png");
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.m_imTitle = Image.createImage((String)"/pix/title.png");
                    this.m_imTitleDark = Image.createImage((String)"/pix/title_dark.png");
                    break;
                }
                case 5: {
                    this.m_imBackground = Image.createImage((String)"/pix/background.png");
                    this.m_iBackgroundWidth = this.m_imBackground.getWidth();
                    Image imPlayer = Image.createImage((String)"/ani/player.png");
                    this.m_spPlayer = new CSprite(imPlayer, 5, 4);
                    this.m_spPlayer.setClipRect(0, 0, 176, 220);
                    this.m_iPlayerPosY = 120;
                    Image imFire1 = Image.createImage((String)"/ani/fire1.png");
                    this.m_moFire1 = new CMO(0, 0);
                    this.m_spFire1 = new CSprite(imFire1, 7, 1);
                    this.m_spFire1.setClipRect(0, 0, 176, 220);
                    this.m_moFire1.setAnimation(0, 7, 655360, CMO.MASK_ANIM_LOOP);
                    this.m_spFire1.m_nFrameCurrent = this.m_moFire1.m_nFrameCurrent;
                    Image imFire2 = Image.createImage((String)"/ani/fire2.png");
                    this.m_moFire2 = new CMO(0, 0);
                    this.m_spFire2 = new CSprite(imFire2, 7, 1);
                    this.m_spFire2.setClipRect(0, 0, 176, 220);
                    this.m_moFire2.setAnimation(0, 7, 655360, CMO.MASK_ANIM_LOOP);
                    this.m_spFire2.m_nFrameCurrent = this.m_moFire2.m_nFrameCurrent;
                    Image imFire3 = Image.createImage((String)"/ani/fire3.png");
                    this.m_moFire3 = new CMO(0, 0);
                    this.m_spFire3 = new CSprite(imFire3, 7, 1);
                    this.m_spFire3.setClipRect(0, 0, 176, 220);
                    this.m_moFire3.setAnimation(0, 7, 655360, CMO.MASK_ANIM_LOOP);
                    this.m_spFire3.m_nFrameCurrent = this.m_moFire3.m_nFrameCurrent;
                    Image imFire4 = Image.createImage((String)"/ani/fire4.png");
                    this.m_moFire4 = new CMO(0, 0);
                    this.m_spFire4 = new CSprite(imFire4, 7, 1);
                    this.m_spFire4.setClipRect(0, 0, 176, 220);
                    this.m_moFire4.setAnimation(0, 7, 655360, CMO.MASK_ANIM_LOOP);
                    this.m_spFire4.m_nFrameCurrent = this.m_moFire4.m_nFrameCurrent;
                    Image imItem1 = Image.createImage((String)"/ani/item1.png");
                    this.m_moItem1 = new CMO(0, 0);
                    this.m_spItem1 = new CSprite(imItem1, 7, 1);
                    this.m_spItem1.setClipRect(0, 0, 176, 156 + this.m_spItem1.m_nFrameHeight);
                    this.m_moItem1.setAnimation(0, 7, 655360, CMO.MASK_ANIM_LOOP);
                    this.m_spItem1.m_nFrameCurrent = this.m_moItem1.m_nFrameCurrent;
                    Image imItem2 = Image.createImage((String)"/ani/item2.png");
                    this.m_moItem2 = new CMO(0, 0);
                    this.m_spItem2 = new CSprite(imItem2, 7, 1);
                    this.m_spItem2.setClipRect(0, 0, 176, 156 + this.m_spItem2.m_nFrameHeight);
                    this.m_moItem2.setAnimation(0, 7, 655360, CMO.MASK_ANIM_LOOP);
                    this.m_spItem2.m_nFrameCurrent = this.m_moItem2.m_nFrameCurrent;
                    Image imItem3 = Image.createImage((String)"/ani/item3.png");
                    this.m_moItem3 = new CMO(0, 0);
                    this.m_spItem3 = new CSprite(imItem3, 7, 1);
                    this.m_spItem3.setClipRect(0, 0, 176, 156 + this.m_spItem3.m_nFrameHeight);
                    this.m_moItem3.setAnimation(0, 7, 655360, CMO.MASK_ANIM_LOOP);
                    this.m_spItem3.m_nFrameCurrent = this.m_moItem3.m_nFrameCurrent;
                    Image imItem4 = Image.createImage((String)"/ani/item4.png");
                    this.m_moItem4 = new CMO(0, 0);
                    this.m_spItem4 = new CSprite(imItem4, 7, 1);
                    this.m_spItem4.setClipRect(0, 0, 176, 156 + this.m_spItem4.m_nFrameHeight);
                    this.m_moItem4.setAnimation(0, 7, 655360, CMO.MASK_ANIM_LOOP);
                    this.m_spItem4.m_nFrameCurrent = this.m_moItem4.m_nFrameCurrent;
                    Image imItem5 = Image.createImage((String)"/ani/item5.png");
                    this.m_moItem5 = new CMO(0, 0);
                    this.m_spItem5 = new CSprite(imItem5, 7, 1);
                    this.m_spItem5.setClipRect(0, 0, 176, 156 + this.m_spItem5.m_nFrameHeight);
                    this.m_moItem5.setAnimation(0, 7, 655360, CMO.MASK_ANIM_LOOP);
                    this.m_spItem5.m_nFrameCurrent = this.m_moItem5.m_nFrameCurrent;
                    Image imBonus = Image.createImage((String)"/pix/bonus.png");
                    this.m_spBonus = new CSprite(imBonus, 4, 1);
                    this.m_spBonus.setClipRect(0, 0, 176, 220);
                    this.m_imSky = Image.createImage((String)"/pix/sky.png");
                    Image imgCloud = Image.createImage((String)"/pix/cloud.png");
                    this.m_spCloud = new CSprite(imgCloud, 1, 2);
                    this.m_spCloud.setClipRect(0, 0, 176, 220);
                    this.m_imHUD = Image.createImage((String)"/pix/hud.png");
                    this.m_iMaxItems = this.m_iBackgroundWidth / 40;
                    int i = 0;
                    while (i < 4) {
                        CStore cStoreLocal = new CStore(i, this.m_spItem1.m_nFrameHeight);
                        int y = 177 - this.m_imBackground.getHeight();
                        switch (i) {
                            case 0: {
                                cStoreLocal.iX = m_iStorePos[0][0];
                                cStoreLocal.iY = m_iStorePos[0][1] + y;
                                break;
                            }
                            case 1: {
                                cStoreLocal.iX = m_iStorePos[1][0];
                                cStoreLocal.iY = m_iStorePos[1][1] + y;
                                break;
                            }
                            case 2: {
                                cStoreLocal.iX = m_iStorePos[2][0];
                                cStoreLocal.iY = m_iStorePos[2][1] + y;
                                break;
                            }
                            case 3: {
                                cStoreLocal.iX = m_iStorePos[3][0];
                                cStoreLocal.iY = m_iStorePos[3][1] + y;
                            }
                        }
                        this.m_vDeliverItems.addElement(cStoreLocal);
                        ++i;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
        }
    }

    public void LoadLanguage() {
        if (this.m_byLanguage == 1) {
            this.loadStrings(new DataInputStream(this.getClass().getResourceAsStream("/lng/de")));
        } else if (this.m_byLanguage == 2) {
            this.loadStrings(new DataInputStream(this.getClass().getResourceAsStream("/lng/fr")));
        } else if (this.m_byLanguage == 3) {
            this.loadStrings(new DataInputStream(this.getClass().getResourceAsStream("/lng/es")));
        } else if (this.m_byLanguage == 4) {
            this.loadStrings(new DataInputStream(this.getClass().getResourceAsStream("/lng/it")));
        } else if (this.m_byLanguage == 5) {
            this.loadStrings(new DataInputStream(this.getClass().getResourceAsStream("/lng/nl")));
        } else {
            this.loadStrings(new DataInputStream(this.getClass().getResourceAsStream("/lng/en")));
        }
    }

    private void addScore(long ltoAdd) {
        this.m_iScore = (int)((long)this.m_iScore + ltoAdd * (long)this.m_iMultiplicatorScore);
        this.m_vScore.addElement(new Long(ltoAdd * (long)this.m_iMultiplicatorScore));
        if (this.m_vScore.size() == 1) {
            this.m_lStartScoreAddTime = this.m_lTime;
        }
    }

    final void changeIngameMode(byte byNewMode) {
        switch (byNewMode) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                this.m_bNoUpdate = true;
                break;
            }
        }
        this.m_byIngameMode = byNewMode;
        this.m_lIngameModeTime = 0L;
        this.m_iIngameModeCount = 0;
    }

    final void changeMode(byte byNewMode) {
        if (this.m_byLoading == 1) {
            this.m_byLoading = byNewMode;
            this.m_bNoUpdate = true;
            return;
        }
        switch (byNewMode) {
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (this.m_byMode == 3 && this.m_byNewLanguage != this.m_byLanguage) {
                    this.m_byLanguage = this.m_byNewLanguage;
                    this.saveRecordData();
                    this.LoadLanguage();
                }
                if (this.m_byMode == 3 || this.m_byMode == 2 || this.m_byMode == 1) {
                    this.m_Menu = new CMenu(this);
                    CMenuItem itemMM = this.m_Menu.m_itemRoot;
                    itemMM.m_strName = this.m_astrLang[0];
                    itemMM.AddMenuItem(1, 10, this.m_astrLang[1]);
                    itemMM.AddMenuItem(2, 1, this.m_astrLang[2]);
                    itemMM.AddMenuItem(3, 14, this.m_astrLang[3]);
                    itemMM.AddMenuItem(4, 16, this.m_astrLang[4]);
                    itemMM.AddMenuItem(5, 18, this.m_astrLang[5]);
                    itemMM.AddMenuItem(6, 1, this.m_astrLang[6]);
                    this.m_Menu.m_itemCurrent = (CMenuItem)itemMM.m_vMenuItems.elementAt(0);
                    CMenuItem itemSM = (CMenuItem)itemMM.m_vMenuItems.elementAt(1);
                    if (this.m_bySoundMode == 0) {
                        itemSM.AddMenuItem(21, 100, this.m_astrLang[7]);
                    }
                    if (this.m_bySoundMode == 1) {
                        itemSM.AddMenuItem(21, 100, this.m_astrLang[8]);
                    }
                    if (this.m_bySoundMode == 2) {
                        itemSM.AddMenuItem(21, 100, this.m_astrLang[9]);
                    }
                    if (this.m_byTutorial > 0) {
                        itemSM.AddMenuItem(25, 200, this.m_astrLang[30]);
                    }
                    if (this.m_byTutorial == 0) {
                        itemSM.AddMenuItem(25, 200, this.m_astrLang[31]);
                    }
                    itemSM = (CMenuItem)itemMM.m_vMenuItems.elementAt(5);
                    itemSM.AddMenuItem(61, 2, this.m_astrLang[10]);
                    itemSM.AddMenuItem(62, -1, this.m_astrLang[11]);
                }
                if (this.m_byMode == 9 || this.m_byMode == 6 || this.m_byMode == 7 || this.m_bySoundMode != 2) break;
                this.m_SndMan.playSound((byte)0, 1);
                break;
            }
            case 5: {
                this.m_iTextScroll = 0;
                this.m_SndMan.stopAllSounds();
                this.changeIngameMode((byte)1);
                break;
            }
            case 6: 
            case 7: {
                this.m_iTextScroll = 0;
                break;
            }
            case 8: {
                break;
            }
        }
        this.m_byMode = byNewMode;
        this.m_lModeTime = 0L;
        this.m_iModeCount = 0;
        this.m_byLoading = 1;
    }

    final void checkMLBlockArraySize() {
        if (this.m_anMLBlocks.length < this.m_anMLBlocks[0] + 3) {
            int[] anTemp = new int[this.m_anMLBlocks.length];
            System.arraycopy(this.m_anMLBlocks, 0, anTemp, 0, this.m_anMLBlocks.length);
            this.m_anMLBlocks = new int[this.m_anMLBlocks.length + 6];
            System.arraycopy(anTemp, 0, this.m_anMLBlocks, 0, anTemp.length);
            System.gc();
        }
    }

    final void checkMLLineArraySize() {
        if (this.m_anMLLines.length < this.m_anMLLines[0] + 3) {
            int[] anTemp = new int[this.m_anMLLines.length];
            System.arraycopy(this.m_anMLLines, 0, anTemp, 0, this.m_anMLLines.length);
            this.m_anMLLines = new int[this.m_anMLLines.length + 6];
            System.arraycopy(anTemp, 0, this.m_anMLLines, 0, anTemp.length);
            System.gc();
        }
    }

    private CItem createRandomGift() {
        CItem cItemLocal = null;
        int r = Math.abs(this.m_random.nextInt()) % this.m_vFreeIDs.size();
        int iFreeID = (Integer)this.m_vFreeIDs.elementAt(r);
        this.m_vFreeIDs.removeElementAt(r);
        int iColor = 0;
        iColor = Math.abs(this.m_random.nextInt()) % 10 == 0 ? 5 : Math.abs(this.m_random.nextInt()) % 4;
        cItemLocal = new CItem(154, 4);
        cItemLocal.iX = this.m_spItem1.m_nFrameWidth + iFreeID * 40 + (this.m_spItem1.m_nFrameWidth >> 1);
        cItemLocal.iY = 0;
        cItemLocal.iColor = iColor;
        cItemLocal.iID = iFreeID;
        cItemLocal.iMode = 0;
        this.m_vItems.addElement(cItemLocal);
        return cItemLocal;
    }

    static final String deleteChar(String strText, char chPattern) {
        int nReplaceIndex = strText.indexOf(chPattern, 0);
        while (nReplaceIndex >= 0) {
            strText = strText.substring(0, nReplaceIndex) + strText.substring(nReplaceIndex + 1);
            nReplaceIndex = strText.indexOf(chPattern, nReplaceIndex);
        }
        return strText;
    }

    public boolean drawMultiLineText(Graphics g, String strText, int y, int nDefaultAnchor, boolean bDrawBoxed, boolean bDrawScrollBar) {
        boolean bSomethingDrawn = false;
        this.m_iMLmaxHeigth = g.getClipHeight();
        if (this.m_sMlt != strText) {
            this.prepareMultiLineText(g, strText, bDrawScrollBar);
        }
        this.m_nMLBlockInfo = 0;
        this.m_nMLBegin = 0;
        this.m_nMLEnd = 0;
        if (16 * this.m_anMLLines[0] <= this.m_iMLmaxHeigth) {
            bDrawScrollBar = false;
        }
        int x_left = g.getClipX();
        int x_right = g.getClipX() + g.getClipWidth() - (bDrawScrollBar ? 8 : 0);
        int x_center = g.getClipWidth() - (bDrawScrollBar ? 8 : 0);
        x_center = g.getClipX() + ((x_center & 1) == 1 ? ++x_center >> 1 : x_center >> 1);
        int nAnchor = nDefaultAnchor;
        int x_default = x_left;
        if ((nDefaultAnchor & 8) == 8) {
            x_default = x_right;
        } else if ((nDefaultAnchor & 1) == 1) {
            x_default = x_center;
        }
        int x = x_default;
        int y_abs = y + g.getClipY();
        nDefaultAnchor |= 0x10;
        int col = g.getColor();
        if (bDrawBoxed) {
            g.setColor(ML_COLOR_TABLE[0]);
            g.fillRect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
            g.setColor(ML_COLOR_TABLE[1]);
            g.drawRect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
            g.setColor(col);
        }
        if (bDrawScrollBar) {
            g.setColor(7380478);
            g.drawRect(g.getClipX() + g.getClipWidth() - 5, g.getClipY(), 4, g.getClipHeight() - 1);
            int BarHeight = g.getClipHeight() * g.getClipHeight() / (16 * this.m_anMLLines[0]);
            int BarY = -y * g.getClipHeight() / (this.m_anMLLines[0] * 16);
            g.fillRect(g.getClipX() + g.getClipWidth() - 5, g.getClipY() + BarY, 4, Math.max(3, BarHeight + 1));
        }
        this.m_nMLBlockInfo = 0;
        boolean bDrawShadowed = false;
        this.m_nMLBegin = Math.abs(y / 16);
        if (y > 0) {
            this.m_nMLBegin = 0;
        }
        if (this.m_nMLBegin > 0) {
            y_abs += 16 * (this.m_nMLBegin - 1);
        }
        this.m_nMLEnd = this.m_nMLBegin + 11;
        this.m_nMLEnd = this.m_nMLEnd > this.m_anMLLines[0] || this.m_nMLEnd + 1 > this.m_anMLLines[0] ? this.m_anMLBlocks[0] : this.m_anMLLines[this.m_nMLEnd + 1];
        int i = this.m_nMLBegin = this.m_anMLLines[this.m_nMLBegin + 1];
        while (i < this.m_nMLEnd) {
            this.m_nMLBlockInfo = this.m_anMLBlocks[i * 3 + 3];
            if ((this.m_nMLBlockInfo & 0x10000000) == 0) {
                y_abs += 16;
            }
            if (this.m_nMLBlockInfo > 0) {
                if ((this.m_nMLBlockInfo & 0xF) > 0) {
                    g.setColor(ML_COLOR_TABLE[this.m_nMLBlockInfo & 0xF]);
                    g.fillRect(g.getClipX(), y_abs, g.getClipWidth() - (bDrawScrollBar ? 8 : 0), 16);
                }
                switch ((this.m_nMLBlockInfo & 0xF000) >> 12) {
                    case 0: {
                        if ((nDefaultAnchor & 4) != 4) break;
                    }
                    case 1: {
                        x = x_left;
                        nAnchor = 20;
                        if ((this.m_nMLBlockInfo & 0x400000) != 0x400000) break;
                        x += 9;
                        break;
                    }
                    case 2: {
                        x = x_center;
                        nAnchor = 17;
                        break;
                    }
                    case 3: {
                        x = x_right;
                        nAnchor = 24;
                    }
                }
                bDrawShadowed = (this.m_nMLBlockInfo & 0x100000) == 0x100000;
            } else if (this.m_nMLBlockInfo == 0) {
                nAnchor = nDefaultAnchor;
                x = x_default;
            }
            this.m_strMLCache = GameCanvas.deleteChar(this.m_sMlt.substring(this.m_anMLBlocks[i * 3 + 1], this.m_anMLBlocks[i * 3 + 2]), '_');
            if ((this.m_nMLBlockInfo & 0x200000) == 0x200000) {
                this.m_strMLCache = this.m_strMLCache + '-';
            }
            this.drawMyString1(g, this.m_strMLCache, x, y_abs, nAnchor);
            bSomethingDrawn = true;
            ++i;
        }
        g.setColor(col);
        return bSomethingDrawn;
    }

    final void drawMyString1(Graphics g, String s, int x, int y, int iAnchor) {
        this.m_BitmapFont1.drawString(g, s, x, y, iAnchor, 1);
    }

    final void drawMyString2(Graphics g, String s, int x, int y, int iAnchor) {
        this.m_BitmapFont2.drawString(g, s, x, y, iAnchor, 1);
    }

    final void drawMyString3(Graphics g, String s, int x, int y, int iAnchor) {
        this.m_BitmapFont3.drawString(g, s, x, y, iAnchor, 0);
    }

    final void drawSoftMenuPoints(Graphics g, String s1, String s2) {
        String strTemp1 = "";
        String strTemp2 = "";
        if (!s1.equals(" ")) {
            strTemp1 = this.m_strLeftSoftKey;
        }
        if (!s2.equals(" ")) {
            strTemp2 = this.m_strRightSoftKey;
        }
        g.setClip(0, 0, 176, 220);
        this.drawMyString1(g, strTemp1 + s1, 0, 220, 36);
        this.drawMyString1(g, strTemp2 + s2, 176, 220, 40);
    }

    final void drawStringShadowed(Graphics g, String s, int x, int y, int iAnchor) {
        if ((iAnchor & 2) == 2) {
            y -= this.m_Font.getHeight() >> 1;
            iAnchor ^= 2;
            iAnchor |= 0x10;
        }
        g.setColor(1);
        g.drawString(s, x + 1, y + 1, iAnchor);
        g.setColor(7380478);
        g.drawString(s, x, y, iAnchor);
    }

    private void getBonusTimeStartRandom() {
        this.m_lBonusStartTime = 50L + this.m_lTime + (long)(Math.abs(this.m_random.nextInt()) % 50);
        this.m_spBonus.m_nFrameCurrent = Math.abs(this.m_random.nextInt()) % 4;
    }

    private CStore getNearestReachableHouse(int iPosX) {
        int iMin = 9999;
        CStore houseRes = null;
        int iDist = 0;
        int iHouseID = 0;
        Enumeration e = this.m_vDeliverItems.elements();
        while (e.hasMoreElements()) {
            CStore cStoreLocal = (CStore)e.nextElement();
            iDist = iHouseID < 3 ? Math.abs(cStoreLocal.iX - iPosX) : Math.abs(cStoreLocal.iX + (this.m_spItem1.m_nFrameWidth >> 1) - iPosX);
            if (iDist < iMin && iDist < 40) {
                iDist = iMin;
                houseRes = cStoreLocal;
            }
            ++iHouseID;
        }
        return houseRes;
    }

    private CItem getNearestReachableItem(int iPosX) {
        int iMin = 9999;
        CItem giftRes = null;
        int iDist = 0;
        Enumeration e = this.m_vItems.elements();
        while (e.hasMoreElements()) {
            CItem cItemLocal = (CItem)e.nextElement();
            if (cItemLocal.iMode != 1 || (iDist = Math.abs(cItemLocal.iX - iPosX)) >= iMin || iDist >= 20) continue;
            iDist = iMin;
            giftRes = cItemLocal;
        }
        return giftRes;
    }

    private int getPlayerGiftsCountByColor(int iColor) {
        int iCount = 0;
        Enumeration e = this.m_vCarryItems.elements();
        while (e.hasMoreElements()) {
            CItem cItemLocal = (CItem)e.nextElement();
            if (cItemLocal.iColor != iColor) continue;
            ++iCount;
        }
        return iCount;
    }

    private CStore getRightHouseForItem(int iPosX, CItem cItemLocal) {
        Object houseRes = null;
        int iDist = 0;
        CStore cStoreLocal = (CStore)this.m_vDeliverItems.elementAt(cItemLocal.iColor);
        iDist = Math.abs(cStoreLocal.iX - iPosX);
        if (iDist < 40) {
            return cStoreLocal;
        }
        return null;
    }

    public void handleKeyPress(int keyCode) {
        int iAction = 0;
        this.m_bKeyLeft = false;
        this.m_bKeyRight = false;
        this.m_bKeyUp = false;
        this.m_bKeyDown = false;
        switch (this.m_byMode) {
            case 2: {
                switch (keyCode) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case 53: {
                        this.changeMode((byte)3);
                    }
                }
                break;
            }
            case 3: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.m_LngMenu.Keypressed(1);
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.m_LngMenu.Keypressed(0);
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        this.m_byNewLanguage = (byte)this.m_LngMenu.m_itemCurrent.m_iID;
                        this.changeMode((byte)4);
                    }
                }
                break;
            }
            case 4: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        iAction = this.m_Menu.Keypressed(1);
                        break;
                    }
                    case -2: 
                    case 56: {
                        iAction = this.m_Menu.Keypressed(0);
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        iAction = this.m_Menu.Keypressed(2);
                        break;
                    }
                    case -7: {
                        if (this.m_Menu.m_itemCurrent.m_itemParent.m_itemParent == null) break;
                        this.m_Menu.m_itemCurrent = this.m_Menu.m_itemCurrent.m_itemParent;
                    }
                }
                switch (iAction) {
                    case 2: {
                        this.m_vEventQueue.addElement(new CEvent(80, null));
                        break;
                    }
                    case 10: {
                        this.changeMode((byte)5);
                        break;
                    }
                    case 14: {
                        this.changeMode((byte)9);
                        break;
                    }
                    case 16: {
                        this.changeMode((byte)6);
                        break;
                    }
                    case 18: {
                        this.changeMode((byte)7);
                        break;
                    }
                    case 100: {
                        this.m_bySoundMode = (byte)(this.m_bySoundMode + 1);
                        this.m_bySoundMode = (byte)(this.m_bySoundMode % 3);
                        if (this.m_bySoundMode == 0) {
                            this.m_Menu.m_itemCurrent.m_strName = this.m_astrLang[7];
                            this.m_SndMan.stopAllSounds();
                        }
                        if (this.m_bySoundMode == 1) {
                            this.m_Menu.m_itemCurrent.m_strName = this.m_astrLang[8];
                            this.m_SndMan.stopAllSounds();
                        }
                        if (this.m_bySoundMode == 2) {
                            this.m_Menu.m_itemCurrent.m_strName = this.m_astrLang[9];
                            this.m_SndMan.playSound((byte)0, 1);
                        }
                        this.saveRecordData();
                        break;
                    }
                    case 200: {
                        if (this.m_byTutorial > 1) {
                            this.m_byTutorial = 1;
                        }
                        this.m_byTutorial = (byte)(this.m_byTutorial + 1);
                        this.m_byTutorial = (byte)(this.m_byTutorial % 2);
                        if (this.m_byTutorial > 0) {
                            this.m_Menu.m_itemCurrent.m_strName = this.m_astrLang[30];
                        }
                        if (this.m_byTutorial == 0) {
                            this.m_Menu.m_itemCurrent.m_strName = this.m_astrLang[31];
                        }
                        this.saveRecordData();
                    }
                }
                break;
            }
            case 5: {
                switch (this.m_byIngameMode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (this.m_byTutorial > 0) {
                            this.changeIngameMode((byte)7);
                            break;
                        }
                        this.changeIngameMode((byte)3);
                        break;
                    }
                    case 3: {
                        if (keyCode != -6) break;
                        this.changeIngameMode((byte)4);
                        break;
                    }
                    case 4: {
                        if (keyCode == -6) {
                            this.changeIngameMode((byte)3);
                        }
                        if (keyCode != -7) break;
                        if (this.m_byTutorial > 1) {
                            this.m_byTutorial = 1;
                        }
                        this.changeIngameMode((byte)0);
                        this.changeMode((byte)4);
                        break;
                    }
                    case 7: {
                        switch (keyCode) {
                            case -7: 
                            case -6: 
                            case -5: 
                            case 53: {
                                this.changeIngameMode((byte)3);
                                this.m_byTutorial = (byte)(this.m_byTutorial + 1);
                                if (this.m_byTutorial <= 4) break;
                                this.m_byTutorial = 0;
                                this.saveRecordData();
                                break;
                            }
                            case -1: 
                            case 50: {
                                if (this.m_iMLmaxHeigth >= this.m_anMLLines[0] * 16) break;
                                if (this.m_iTextScroll < 0) {
                                    this.m_iTextScroll += 8;
                                }
                                if (this.m_iTextScroll <= 0) break;
                                this.m_iTextScroll = 0;
                                break;
                            }
                            case -2: 
                            case 56: {
                                if (this.m_iMLmaxHeigth >= this.m_anMLLines[0] * 16) break;
                                int nScrollTemp = this.m_iMLmaxHeigth - this.m_anMLLines[0] * 16;
                                if (this.m_iTextScroll > nScrollTemp) {
                                    this.m_iTextScroll -= 8;
                                }
                                if (this.m_iTextScroll >= nScrollTemp) break;
                                this.m_iTextScroll = nScrollTemp;
                            }
                        }
                        break;
                    }
                    case 6: {
                        if (keyCode != -6 && keyCode != -5 && keyCode != -7) break;
                        this.changeIngameMode((byte)0);
                        this.m_iLastScore = this.m_Highscore.isScoreInHighscore(this.m_iScore);
                        if (this.m_iLastScore >= 0) {
                            this.changeMode((byte)8);
                            break;
                        }
                        this.changeMode((byte)4);
                        break;
                    }
                }
                break;
            }
            case 9: {
                if (keyCode != -7 && keyCode != -5 && keyCode != 53) break;
                this.changeMode((byte)4);
                break;
            }
            case 6: {
                if (keyCode != -7 && keyCode != -5 && keyCode != 53) break;
                this.changeMode((byte)4);
                break;
            }
            case 7: {
                if (keyCode != -7 && keyCode != -5 && keyCode != 53) break;
                this.changeMode((byte)4);
                break;
            }
            case 8: {
                if (keyCode == -7) {
                    this.m_StringInput.deleteLastChar();
                    break;
                }
                if (keyCode == -6) {
                    if (this.m_bySoundMode == 2) {
                        this.m_SndMan.playSound((byte)0, 1);
                    }
                    this.changeMode((byte)9);
                    this.m_Highscore.addHighscore(this.m_StringInput.m_strCur, this.m_iScore);
                    this.m_iHighscoreHighlight = this.m_iLastScore;
                    this.saveRecordData();
                    break;
                }
                this.m_StringInput.sendKey(keyCode);
            }
        }
        if (keyCode == -3 || keyCode == 52) {
            this.m_bKeyLeft = true;
        }
        if (keyCode == -4 || keyCode == 54) {
            this.m_bKeyRight = true;
        }
        if (keyCode == -1 || keyCode == 50) {
            this.m_bKeyUp = true;
        }
        if (keyCode == -2 || keyCode == 56) {
            this.m_bKeyDown = true;
        }
    }

    public void handleKeyRelease(int keyCode) {
        switch (this.m_byMode) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 9: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
        }
        if (keyCode == -3 || keyCode == 52) {
            this.m_bKeyLeft = false;
        }
        if (keyCode == -4 || keyCode == 54) {
            this.m_bKeyRight = false;
        }
        if (keyCode == -1 || keyCode == 50) {
            this.m_bKeyUp = false;
        }
        if (keyCode == -2 || keyCode == 56) {
            this.m_bKeyDown = false;
        }
    }

    public void hideNotify() {
        if (this.m_byIngameMode == 3) {
            this.changeIngameMode((byte)4);
        }
        this.m_SndMan.stopAllSounds();
    }

    static final int indexOfNextWrap(String strText, int nBegin, int nEnd) {
        int i = nBegin;
        while (i < nEnd) {
            int b = 0;
            while (b < ML_WRAPCHARS.length) {
                if (ML_WRAPCHARS[b] == strText.charAt(i)) {
                    return i;
                }
                b = (byte)(b + 1);
            }
            ++i;
        }
        return -1;
    }

    private void initLevel(int iLevelID1) {
        this.m_iLevel = iLevelID1;
        this.m_iItemsToDeliverLevel = (this.m_iLevel + 1) * 3;
        this.m_lLevelEndTime = this.m_lTime + 3931800L;
        this.m_lLevelTime = 0L;
    }

    public void keyPressed(int keyCode) {
        this.m_vEventQueue.addElement(new CEvent(48, new Integer(keyCode)));
    }

    public void keyReleased(int keyCode) {
        this.m_vEventQueue.addElement(new CEvent(64, new Integer(keyCode)));
    }

    final void loadRecordData() {
        int iR = this.m_RecordHandler.BeginRead();
        if (iR > 0) {
            byte byVersion = this.m_RecordHandler.ReadByte();
            if (11 != byVersion) {
                return;
            }
            this.m_byNewLanguage = this.m_byLanguage = this.m_RecordHandler.ReadByte();
            this.m_bySoundMode = this.m_RecordHandler.ReadByte();
            this.m_byTutorial = this.m_RecordHandler.ReadByte();
            if (this.m_byTutorial > 1) {
                this.m_byTutorial = 1;
            }
            this.m_Highscore.loadHighscoreFromRecord(this.m_RecordHandler);
        }
        this.m_RecordHandler.End();
    }

    final void loadStrings(DataInputStream in) {
        try {
            int numStrings = in.readInt();
            int highestID = in.readInt();
            if (highestID > this.m_astrLang.length - 1) {
                String[] oldStrings = this.m_astrLang;
                this.m_astrLang = new String[highestID + 1];
                System.arraycopy(oldStrings, 0, this.m_astrLang, 0, oldStrings.length);
            }
            int i = 0;
            while (i < numStrings) {
                int key = in.readInt();
                this.m_astrLang[key] = in.readUTF();
                System.gc();
                ++i;
            }
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        int nReplaceIndex = this.m_astrLang[21].indexOf("$VERSION$");
        this.m_astrLang[21] = this.m_astrLang[21].substring(0, nReplaceIndex) + this.parent.getAppProperty("MIDlet-Version") + this.m_astrLang[21].substring(nReplaceIndex + 9);
        nReplaceIndex = this.m_astrLang[21].indexOf("$NAME$");
        this.m_astrLang[21] = this.m_astrLang[21].substring(0, nReplaceIndex) + this.parent.getAppProperty("MIDlet-Name") + this.m_astrLang[21].substring(nReplaceIndex + 6);
    }

    public synchronized void paint(Graphics g) {
        if (this.m_byLoading != 1) {
            g.setClip(0, 0, 176, 220);
            g.setColor(1);
            g.fillRect(0, 0, 176, 220);
            if (this.m_imIntro != null && this.m_byMode == 1) {
                g.drawImage(this.m_imIntro, 88, 110, 2 | 1);
            }
            g.setColor(7380478);
            if (this.m_byNewLanguage == 1) {
                this.drawStringShadowed(g, "l\u00e4dt...", 3, 217, 36);
            } else if (this.m_byNewLanguage == 2) {
                this.drawStringShadowed(g, "chargement...", 3, 217, 36);
            } else if (this.m_byNewLanguage == 3) {
                this.drawStringShadowed(g, "cargando...", 3, 217, 36);
            } else if (this.m_byNewLanguage == 4) {
                this.drawStringShadowed(g, "caricando...", 3, 217, 36);
            } else if (this.m_byNewLanguage == 5) {
                this.drawStringShadowed(g, "bezig met laden...", 3, 217, 36);
            } else {
                this.drawStringShadowed(g, "loading...", 3, 217, 36);
            }
            this.m_bNoUpdate = false;
            return;
        }
        g.setClip(0, 0, 176, 220);
        g.setColor(1);
        g.fillRect(0, 0, 176, 220);
        block0 : switch (this.m_byMode) {
            case 2: {
                g.setColor(0xFFFFFFE);
                g.fillRect(0, 0, 176, 220);
                if (this.m_imIntro == null) break;
                g.drawImage(this.m_imIntro, 88, 110, 2 | 1);
                break;
            }
            case 3: {
                g.setClip(0, 0, 176, 220);
                g.drawImage(this.m_imTitle, 0, 0, 0);
                this.m_LngMenu.draw(g);
                g.setClip(0, 0, 176, 220);
                g.drawImage(this.m_imNext, 2, 218, 36);
                break;
            }
            case 4: {
                g.setClip(0, 0, 176, 220);
                g.drawImage(this.m_imTitle, 0, 0, 0);
                this.renameMenu();
                this.m_Menu.draw(g);
                g.setClip(0, 0, 176, 220);
                g.drawImage(this.m_imNext, 2, 218, 36);
                if (this.m_Menu.m_itemCurrent.m_itemParent.m_itemParent == null) break;
                g.drawImage(this.m_imBack, 174, 218, 40);
                break;
            }
            case 5: {
                switch (this.m_byIngameMode) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        g.setClip(0, 0, 176, 220);
                        g.setColor(1);
                        g.fillRect(0, 0, 176, 220);
                        g.setColor(7380478);
                        g.drawString(this.m_astrLang[23], 3, 217, 36);
                        this.m_bNoUpdate = false;
                        break block0;
                    }
                    case 2: {
                        this.paintGame(g, 0, 0);
                        if (this.m_lIngameModeTime / 6553L % 15L >= 8L) break;
                        g.setClip(0, 94, 176, 220);
                        this.drawMultiLineText(g, this.m_astrLang[29], this.m_iTextScroll, 17, false, true);
                        break block0;
                    }
                    case 3: {
                        this.paintGame(g, 0, 0);
                        break block0;
                    }
                    case 6: {
                        this.paintGame(g, 0, 0);
                        this.drawMyString1(g, this.m_astrLang[24], 88, 110, 17);
                        g.setClip(0, 0, 176, 220);
                        g.drawImage(this.m_imNext, 2, 218, 36);
                        break block0;
                    }
                    case 4: {
                        this.paintGame(g, 0, 0);
                        g.setClip(0, 0, 176, 220);
                        this.drawMyString1(g, this.m_astrLang[12], 88, 110, 17);
                        g.setClip(0, 0, 176, 220);
                        g.drawImage(this.m_imNext, 2, 218, 36);
                        g.drawImage(this.m_imBack, 174, 218, 40);
                        break block0;
                    }
                    case 7: {
                        this.paintGame(g, 0, 0);
                        switch (this.m_byTutorial) {
                            case 1: {
                                g.setClip(2, 2, 174, 218);
                                this.drawMultiLineText(g, this.m_astrLang[32], this.m_iTextScroll, 17, false, true);
                                break;
                            }
                            case 2: {
                                g.setClip(2, 2, 174, 218);
                                this.drawMultiLineText(g, this.m_astrLang[33], this.m_iTextScroll, 17, false, true);
                                break;
                            }
                            case 3: {
                                g.setClip(2, 2, 174, 218);
                                this.drawMultiLineText(g, this.m_astrLang[34], this.m_iTextScroll, 17, false, true);
                                break;
                            }
                            case 4: {
                                g.setClip(2, 2, 174, 218);
                                this.drawMultiLineText(g, this.m_astrLang[35], this.m_iTextScroll, 17, false, true);
                            }
                        }
                        g.setClip(0, 0, 176, 220);
                        g.drawImage(this.m_imNext, 2, 218, 36);
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                g.setClip(0, 0, 176, 220);
                g.drawImage(this.m_imTitleDark, 0, 0, 0);
                this.m_Highscore.draw(g, -1);
                g.setClip(0, 0, 176, 220);
                g.drawImage(this.m_imBack, 174, 218, 40);
                break;
            }
            case 6: {
                g.setClip(0, 0, 176, 220);
                g.drawImage(this.m_imTitleDark, 0, 0, 0);
                this.drawMyString1(g, "-" + this.m_astrLang[4] + "-", 88, 5, 17);
                g.setClip(5, 25, 166, 160);
                this.drawMultiLineText(g, this.m_astrLang[20], this.m_iTextScroll, 17, false, true);
                g.setClip(0, 0, 176, 220);
                g.drawImage(this.m_imBack, 174, 218, 40);
                break;
            }
            case 7: {
                g.setClip(0, 0, 176, 220);
                g.drawImage(this.m_imTitleDark, 0, 0, 0);
                this.drawMyString1(g, "-" + this.m_astrLang[5] + "-", 88, 5, 17);
                g.setClip(5, 25, 166, 160);
                this.drawMultiLineText(g, this.m_astrLang[21], this.m_iTextScroll, 17, false, true);
                g.setClip(0, 0, 176, 220);
                g.drawImage(this.m_imBack, 174, 218, 40);
                break;
            }
            case 8: {
                g.setClip(0, 0, 176, 220);
                g.drawImage(this.m_imTitleDark, 0, 0, 0);
                this.drawMyString1(g, this.m_astrLang[18], 88, 105, 33);
                this.m_StringInput.draw(g, 88, 115);
                g.setClip(0, 0, 176, 220);
                g.drawImage(this.m_imNext, 2, 218, 36);
                g.drawImage(this.m_imBack, 174, 218, 40);
            }
        }
    }

    final void paintGame(Graphics g, int iXOffset, int iYOffset) {
        long lRestTime;
        g.setClip(0, 0, 176, 220);
        g.drawImage(this.m_imSky, 0, 0, 20);
        g.drawImage(this.m_imSky, 44, 0, 20);
        g.drawImage(this.m_imSky, 88, 0, 20);
        g.drawImage(this.m_imSky, 132, 0, 20);
        g.setClip(0, 0, 176, 220);
        if (this.m_byIngameMode == 3) {
            this.m_iAutoScrollClouds += 200;
        }
        int i = 0;
        while (i < 4) {
            this.m_spCloud.m_nFrameCurrent = this.m_aClouds[0][i];
            this.m_spCloud.iX = (this.m_aClouds[1][i] + this.m_iBackgroundPosX - (this.m_iAutoScrollClouds >> 8)) % (200 + this.m_spCloud.m_nFrameWidth) + 200;
            this.m_spCloud.iY = this.m_aClouds[2][i];
            this.m_spCloud.draw(g);
            ++i;
        }
        g.setClip(0, 0, 176, 220);
        g.drawImage(this.m_imBackground, this.m_iBackgroundPosX, 177, 36);
        g.setClip(0, 0, 176, 220);
        this.m_spFire1.iX = m_iFirePos[0][0] + this.m_iBackgroundPosX;
        this.m_spFire1.iY = m_iFirePos[0][1] + 177 - this.m_imBackground.getHeight();
        this.m_spFire1.draw(g);
        g.setClip(0, 0, 176, 220);
        this.m_spFire2.iX = m_iFirePos[1][0] + this.m_iBackgroundPosX;
        this.m_spFire2.iY = m_iFirePos[1][1] + 177 - this.m_imBackground.getHeight();
        this.m_spFire2.draw(g);
        g.setClip(0, 0, 176, 220);
        this.m_spFire3.iX = m_iFirePos[2][0] + this.m_iBackgroundPosX;
        this.m_spFire3.iY = m_iFirePos[2][1] + 177 - this.m_imBackground.getHeight();
        this.m_spFire3.draw(g);
        g.setClip(0, 0, 176, 220);
        this.m_spFire4.iX = m_iFirePos[3][0] + this.m_iBackgroundPosX;
        this.m_spFire4.iY = m_iFirePos[3][1] + 177 - this.m_imBackground.getHeight();
        this.m_spFire4.draw(g);
        Enumeration e = this.m_vDeliverItems.elements();
        while (e.hasMoreElements()) {
            CStore cStoreLocal = (CStore)e.nextElement();
            this.DrawItemList(g, cStoreLocal.m_vItems);
        }
        this.m_spPlayer.iX = this.m_iBackgroundPosX + this.m_iPlayerPosX - (this.m_spPlayer.m_nFrameWidth >> 1);
        this.m_spPlayer.iY = this.m_iBackgroundPosY + this.m_iPlayerPosY;
        this.m_spPlayer.draw(g);
        g.setClip(0, 0, 176, 220);
        this.DrawItemList(g, this.m_vCarryItems);
        g.setClip(0, 0, 176, 220);
        this.DrawItemList(g, this.m_vItems);
        g.setClip(0, 0, 176, 220);
        if (this.m_iBonusPosX > -10) {
            this.m_spBonus.iX = this.m_iBackgroundPosX + this.m_iBonusPosX - (this.m_spBonus.m_nFrameWidth >> 1);
            this.m_spBonus.iY = this.m_iBackgroundPosY + this.m_iBonusPosY - (this.m_spBonus.m_nFrameWidth >> 1);
            this.m_spBonus.draw(g);
        }
        g.setClip(0, 0, 176, 220);
        g.drawImage(this.m_imHUD, 0, 220 - this.m_imHUD.getHeight(), 20);
        g.setColor(0xFFFFFFE);
        this.drawMyString3(g, "" + this.m_iScore, 2, 184, 20);
        if (this.m_vScore.size() > 0 && this.m_lTime - this.m_lStartScoreAddTime > 2L) {
            long lToAdd = (Long)this.m_vScore.elementAt(0);
            this.drawMyString3(g, "+" + lToAdd, 2, 201, 20);
        }
        if ((lRestTime = (this.m_lLevelEndTime - this.m_lTime) / 65530L) > 10L || this.m_lTime % 10L > 3L) {
            this.drawMyString3(g, "" + lRestTime, 98, 184, 17);
        }
        if (this.m_iMultiplicatorScore > 1 && this.m_lTime / 6553L % 10L > 4L) {
            this.drawMyString3(g, "x" + this.m_iMultiplicatorScore, 98, 201, 17);
        }
        if ((this.m_lLevelEndTime - this.m_lTime) / 6553L > 50L || (this.m_lTime / 6553L + 1L) % 10L > 3L) {
            this.drawMyString3(g, "" + (this.m_iLevel + 1) + ". " + this.m_astrLang[28] + " ", 176, 184, 24);
        }
        this.drawMyString3(g, "" + this.m_iItemsLevel + "/" + this.m_iItemsToDeliverLevel + " ", 176, 201, 24);
    }

    private void pickUpItem(CItem cItemLocal) {
        cItemLocal.iSunk = 0;
        this.m_vCarryItems.addElement(cItemLocal);
        this.m_vItems.removeElement(cItemLocal);
        this.m_vFreeIDs.addElement(new Integer(cItemLocal.iID));
        this.addScore(5L);
        if (this.m_bySoundMode == 1 || this.m_bySoundMode == 2) {
            this.m_SndMan.playSound((byte)4, 1);
        }
    }

    final void prepareMultiLineText(Graphics g, String strText, boolean bDrawScrollBar) {
        if (this.m_sMlt != strText) {
            this.m_anMLBlocks[0] = 1;
            this.m_anMLLines[0] = 2;
            this.m_anMLLines[1] = 0;
            this.m_iMLmaxLineWidth = g.getClipWidth() - (bDrawScrollBar ? 8 : 0) - 2;
            this.m_nMLBlockInfo = 0;
            int m_nMLBlockInfoBefore = 0;
            this.m_nMLBegin = 0;
            this.m_nMLEnd = 0;
            int nBlockNumber = 0;
            int nParagraphBegin = 0;
            int nParagraphEnd = 0;
            int nInfoBlockEnd = 0;
            int nlength = 0;
            int nlengthBefore = 0;
            int nAutoWrap = 0;
            int nOptionalWrap = 0;
            boolean bOptionalWrap = false;
            boolean bIsList = false;
            int nIndent = 0;
            nParagraphEnd = strText.indexOf(94, nParagraphBegin);
            if (nParagraphEnd < 0) {
                nParagraphEnd = strText.length();
            }
            while (nParagraphBegin <= nParagraphEnd) {
                nIndent = 0;
                nInfoBlockEnd = strText.indexOf(124, nParagraphBegin + 1);
                if (nInfoBlockEnd < 0 || nInfoBlockEnd > nParagraphEnd) {
                    this.m_nMLBlockInfo = 0;
                    if (nParagraphBegin <= 1) {
                        this.m_nMLBlockInfo |= 0x10000000;
                    }
                } else {
                    this.m_nMLBlockInfo = Integer.parseInt(strText.substring(nParagraphBegin, nInfoBlockEnd), 16);
                    if (nParagraphBegin <= 1) {
                        this.m_nMLBlockInfo |= 0x10000000;
                    }
                    nParagraphBegin = nInfoBlockEnd + 1;
                }
                nlength = this.m_BitmapFont1.getStringWidth(GameCanvas.deleteChar(strText.substring(nParagraphBegin, nParagraphEnd), '_'), 1);
                if ((this.m_nMLBlockInfo & 0x10000000) == 0x10000000 && nlengthBefore > 0 && nlength + nlengthBefore > this.m_iMLmaxLineWidth) {
                    if ((m_nMLBlockInfoBefore & 0xF) > 0) {
                        this.m_nMLBlockInfo |= m_nMLBlockInfoBefore & 0xF;
                    }
                    this.m_nMLBlockInfo &= 0xEFFFFFFF;
                }
                if (nlength > this.m_iMLmaxLineWidth) {
                    nAutoWrap = this.m_nMLBegin = nParagraphBegin;
                    this.m_nMLBlockInfo &= 0xFFDFFFFF;
                    bIsList = strText.charAt(nParagraphBegin) == '-';
                    while (nAutoWrap <= nParagraphEnd) {
                        this.m_nMLEnd = GameCanvas.indexOfNextWrap(strText, nAutoWrap, nParagraphEnd);
                        nOptionalWrap = strText.indexOf(95, nAutoWrap);
                        if (nOptionalWrap >= 0 && (nOptionalWrap < this.m_nMLEnd || this.m_nMLEnd < 0)) {
                            this.m_nMLEnd = nOptionalWrap;
                        }
                        if (this.m_nMLEnd < 0 || this.m_nMLEnd > nParagraphEnd) {
                            this.m_nMLEnd = nParagraphEnd;
                        }
                        this.m_strMLCache = GameCanvas.deleteChar(strText.substring(this.m_nMLBegin, this.m_nMLEnd), '_');
                        nlength = this.m_BitmapFont1.getStringWidth(this.m_strMLCache, 1) + nIndent;
                        if (nlength > this.m_iMLmaxLineWidth) {
                            this.checkMLBlockArraySize();
                            if ((this.m_nMLBlockInfo & 0x10000000) == 0) {
                                this.checkMLLineArraySize();
                                int n = this.m_anMLLines[0];
                                this.m_anMLLines[0] = n + 1;
                                this.m_anMLLines[n] = nBlockNumber;
                            }
                            ++nBlockNumber;
                            int n = this.m_anMLBlocks[0];
                            this.m_anMLBlocks[0] = n + 1;
                            this.m_anMLBlocks[n] = this.m_nMLBegin;
                            int n2 = this.m_anMLBlocks[0];
                            this.m_anMLBlocks[0] = n2 + 1;
                            this.m_anMLBlocks[n2] = nAutoWrap - (strText.charAt(nAutoWrap - 1) == ' ' ? 1 : 0);
                            int n3 = this.m_anMLBlocks[0];
                            this.m_anMLBlocks[0] = n3 + 1;
                            this.m_anMLBlocks[n3] = this.m_nMLBlockInfo;
                            this.m_nMLBlockInfo &= 0xEFFFFFFF;
                            this.m_nMLBegin = nAutoWrap;
                            if (bIsList) {
                                this.m_nMLBlockInfo |= 0x400000;
                                nIndent = 9;
                            } else {
                                this.m_nMLBlockInfo &= 0xFFBFFFFF;
                                nIndent = 0;
                            }
                        }
                        nAutoWrap = this.m_nMLEnd + 1;
                        if (nOptionalWrap == this.m_nMLEnd) {
                            this.m_nMLBlockInfo |= 0x200000;
                            continue;
                        }
                        this.m_nMLBlockInfo &= 0xFFDFFFFF;
                    }
                    this.checkMLBlockArraySize();
                    if ((this.m_nMLBlockInfo & 0x10000000) == 0) {
                        this.checkMLLineArraySize();
                        int n = this.m_anMLLines[0];
                        this.m_anMLLines[0] = n + 1;
                        this.m_anMLLines[n] = nBlockNumber;
                    }
                    ++nBlockNumber;
                    int n = this.m_anMLBlocks[0];
                    this.m_anMLBlocks[0] = n + 1;
                    this.m_anMLBlocks[n] = this.m_nMLBegin;
                    int n4 = this.m_anMLBlocks[0];
                    this.m_anMLBlocks[0] = n4 + 1;
                    this.m_anMLBlocks[n4] = nParagraphEnd;
                    int n5 = this.m_anMLBlocks[0];
                    this.m_anMLBlocks[0] = n5 + 1;
                    this.m_anMLBlocks[n5] = this.m_nMLBlockInfo;
                } else if (nParagraphBegin != nParagraphEnd) {
                    this.checkMLBlockArraySize();
                    if ((this.m_nMLBlockInfo & 0x10000000) == 0) {
                        this.checkMLLineArraySize();
                        int n = this.m_anMLLines[0];
                        this.m_anMLLines[0] = n + 1;
                        this.m_anMLLines[n] = nBlockNumber;
                    }
                    ++nBlockNumber;
                    int n = this.m_anMLBlocks[0];
                    this.m_anMLBlocks[0] = n + 1;
                    this.m_anMLBlocks[n] = nParagraphBegin;
                    int n6 = this.m_anMLBlocks[0];
                    this.m_anMLBlocks[0] = n6 + 1;
                    this.m_anMLBlocks[n6] = nParagraphEnd;
                    int n7 = this.m_anMLBlocks[0];
                    this.m_anMLBlocks[0] = n7 + 1;
                    this.m_anMLBlocks[n7] = this.m_nMLBlockInfo;
                }
                nlengthBefore = nlength;
                nParagraphBegin = nParagraphEnd + 1;
                nParagraphEnd = strText.indexOf(94, nParagraphBegin);
                if (nParagraphEnd < 0) {
                    nParagraphEnd = strText.length();
                }
                m_nMLBlockInfoBefore = this.m_nMLBlockInfo;
            }
            this.m_anMLBlocks[0] = (this.m_anMLBlocks[0] - 1) / 3;
            this.m_anMLLines[0] = this.m_anMLLines[0] - 1;
            this.m_sMlt = strText;
            System.gc();
        }
    }

    final void renameMenu() {
        Enumeration e = this.m_Menu.m_itemCurrent.m_itemParent.m_vMenuItems.elements();
        while (e.hasMoreElements()) {
            CMenuItem mi = (CMenuItem)e.nextElement();
            if (mi.m_iID == 25 && this.m_byTutorial > 0) {
                mi.m_strName = this.m_astrLang[30];
            }
            if (mi.m_iID != 25 || this.m_byTutorial != 0) continue;
            mi.m_strName = this.m_astrLang[31];
        }
    }

    private void resetGame() {
        this.m_vItems.removeAllElements();
        this.m_vCarryItems.removeAllElements();
        Enumeration e = this.m_vDeliverItems.elements();
        while (e.hasMoreElements()) {
            CStore cStoreLocal = (CStore)e.nextElement();
            cStoreLocal.removeAllElements();
        }
        this.m_iLevel = 0;
        this.m_lTime = 0L;
        this.m_iScore = 0;
        this.m_iMultiplicatorScore = 1;
        this.m_iBonusCatchedCount = 0;
        this.m_iBonusPosX = -10;
        this.getBonusTimeStartRandom();
        this.m_iItemsLevel = 0;
        this.m_lLastItemCreateTime = 0L;
        this.m_iPlayerPosX = this.m_iBackgroundWidth >> 1;
        this.m_vFreeIDs.removeAllElements();
        int i = 0;
        while (i < this.m_iMaxItems) {
            this.m_vFreeIDs.addElement(new Integer(i));
            ++i;
        }
        this.m_vScore.removeAllElements();
        this.m_iBackgroundPosX = this.m_iOneLayerHousesX = 88 - (this.m_iBackgroundWidth >> 1);
        this.m_iAutoScrollClouds = 51200;
        int i2 = 0;
        while (i2 < 4) {
            this.m_aClouds[0][i2] = Math.abs(this.m_random.nextInt() % 2);
            this.m_aClouds[1][i2] = Math.abs(this.m_random.nextInt() % (200 - this.m_spCloud.m_nFrameWidth));
            this.m_aClouds[2][i2] = Math.abs(this.m_random.nextInt() % 100) + 0;
            ++i2;
        }
        this.initLevel(0);
    }

    public final void run() {
        while (this.parent.m_bRunning) {
            this.T = this.U;
            this.U = System.currentTimeMillis();
            Enumeration enumeration = this.m_vEventQueue.elements();
            while (enumeration.hasMoreElements()) {
                CEvent e = (CEvent)enumeration.nextElement();
                switch (e.m_iType) {
                    case 16: {
                        this.repaint();
                        this.serviceRepaints();
                        break;
                    }
                    case 32: {
                        this.update(6553);
                        break;
                    }
                    case 48: {
                        this.handleKeyPress((Integer)e.m_oEventData);
                        break;
                    }
                    case 64: {
                        this.handleKeyRelease((Integer)e.m_oEventData);
                        break;
                    }
                    case 80: {
                        this.m_SndMan.stopAllSounds();
                        this.parent.exit();
                        return;
                    }
                }
            }
            this.m_vEventQueue.removeAllElements();
            this.m_vEventQueue.addElement(new CEvent(32, null));
            this.m_vEventQueue.addElement(new CEvent(16, null));
            try {
                this.T = System.currentTimeMillis() - this.U;
                if (this.T < 0L || this.T >= 100L) continue;
                Thread.sleep(100L - this.T);
            }
            catch (Exception e) {
            }
        }
        this.parent.notifyDestroyed();
        this.parent.destroyApp(true);
    }

    final void saveRecordData() {
        this.m_RecordHandler.BeginWrite();
        this.m_RecordHandler.WriteByte((byte)11);
        this.m_RecordHandler.WriteByte(this.m_byLanguage);
        this.m_RecordHandler.WriteByte(this.m_bySoundMode);
        if (this.m_byTutorial > 1) {
            this.m_byTutorial = 1;
        }
        this.m_RecordHandler.WriteByte(this.m_byTutorial);
        this.m_Highscore.saveHighscoreToRecord(this.m_RecordHandler);
        this.m_RecordHandler.End();
    }

    final void trimMLArrays() {
        int nUsedSize = this.m_anMLBlocks[0] * 3 + 1;
        int[] anTemp = new int[nUsedSize];
        System.arraycopy(this.m_anMLBlocks, 0, anTemp, 0, nUsedSize);
        this.m_anMLBlocks = new int[nUsedSize];
        System.arraycopy(anTemp, 0, this.m_anMLBlocks, 0, nUsedSize);
        nUsedSize = this.m_anMLLines[0] + 1;
        anTemp = new int[nUsedSize];
        System.arraycopy(this.m_anMLLines, 0, anTemp, 0, nUsedSize);
        this.m_anMLLines = new int[nUsedSize];
        System.arraycopy(anTemp, 0, this.m_anMLLines, 0, nUsedSize);
        anTemp = null;
        System.gc();
    }

    public synchronized void update(int iTick) {
        block26: {
            if (this.m_bNoUpdate) {
                return;
            }
            if (this.m_byLoading > 1) {
                this.changeMode(this.m_byLoading);
                return;
            }
            this.m_lModeTime += (long)iTick;
            try {
                if (this.m_byMode == 1) {
                    this.Init();
                    this.changeMode((byte)2);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            block1 : switch (this.m_byMode) {
                case 2: {
                    if (this.m_lModeTime <= 98304L) break;
                    this.changeMode((byte)3);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    this.m_lIngameModeTime += (long)iTick;
                    switch (this.m_byIngameMode) {
                        case 1: {
                            this.resetGame();
                            this.changeIngameMode((byte)2);
                            break block1;
                        }
                        case 2: {
                            break block1;
                        }
                        case 3: {
                            CItem cItemLocal;
                            this.updateGame(iTick);
                            if (this.m_byTutorial == 2 && (cItemLocal = this.getNearestReachableItem(this.m_iPlayerPosX)) != null) {
                                this.changeIngameMode((byte)7);
                            }
                            if (this.m_byTutorial == 3 && !this.m_vCarryItems.isEmpty()) {
                                this.changeIngameMode((byte)7);
                            }
                            if (this.m_byTutorial != 4) break;
                            cItemLocal = (CItem)this.m_vCarryItems.lastElement();
                            CStore cStoreLocal = cItemLocal.iColor < 4 ? this.getRightHouseForItem(this.m_iPlayerPosX, cItemLocal) : this.getNearestReachableHouse(this.m_iPlayerPosX);
                            if (cStoreLocal != null) {
                                this.changeIngameMode((byte)7);
                            }
                            break block26;
                        }
                    }
                    break;
                }
                case 9: {
                    break;
                }
                case 6: 
                case 7: {
                    if (this.m_iMLmaxHeigth >= this.m_anMLLines[0] * 16) break;
                    if (this.m_bKeyUp) {
                        if (this.m_iTextScroll < 0) {
                            this.m_iTextScroll += 8;
                        }
                        if (this.m_iTextScroll > 0) {
                            this.m_iTextScroll = 0;
                        }
                    }
                    if (this.m_bKeyDown) {
                        int nScrollTemp = this.m_iMLmaxHeigth - this.m_anMLLines[0] * 16;
                        if (this.m_iTextScroll > nScrollTemp) {
                            this.m_iTextScroll -= 8;
                        }
                        if (this.m_iTextScroll < nScrollTemp) {
                            this.m_iTextScroll = nScrollTemp;
                        }
                    }
                    break;
                }
            }
        }
    }

    final void updateGame(int iTick) {
        Enumeration e;
        CItem cItemLocal;
        this.m_lTime += (long)iTick;
        this.m_lLevelTime += (long)iTick;
        if (this.m_bKeyRight && this.m_iPlayerPosX < this.m_iBackgroundWidth) {
            this.m_iPlayerPosX += 10;
            this.m_spPlayer.m_nFrameCurrent = this.m_iPlayerAniFrame = (this.m_iPlayerAniFrame + 1) % 10;
            this.m_iPlayerMode = 2;
        }
        if (this.m_bKeyLeft && this.m_iPlayerPosX > 0) {
            this.m_iPlayerPosX -= 10;
            this.m_iPlayerAniFrame = (this.m_iPlayerAniFrame + 1) % 10;
            this.m_spPlayer.m_nFrameCurrent = 10 + this.m_iPlayerAniFrame;
            this.m_iPlayerMode = 1;
        }
        if (this.m_bKeyDown && this.m_vCarryItems.size() < 3 && (cItemLocal = this.getNearestReachableItem(this.m_iPlayerPosX)) != null) {
            if (cItemLocal.iSunk <= 2) {
                this.pickUpItem(cItemLocal);
            } else {
                cItemLocal.m_lStartTime += 26212L;
                if (cItemLocal.m_lStartTime > this.m_lTime) {
                    cItemLocal.iSunk = 0;
                    cItemLocal.m_lStartTime = this.m_lTime;
                    this.pickUpItem(cItemLocal);
                }
            }
        }
        if (this.m_lTime >= this.m_lLevelEndTime) {
            this.changeIngameMode((byte)6);
            if (this.m_bySoundMode == 1 || this.m_bySoundMode == 2) {
                this.m_SndMan.playSound((byte)1, 1);
            }
        } else if (this.m_bKeyUp && !this.m_vCarryItems.isEmpty()) {
            int iAdded;
            cItemLocal = (CItem)this.m_vCarryItems.lastElement();
            CStore cStoreLocal = null;
            cStoreLocal = cItemLocal.iColor < 4 ? this.getRightHouseForItem(this.m_iPlayerPosX, cItemLocal) : this.getNearestReachableHouse(this.m_iPlayerPosX);
            if (cStoreLocal != null && (iAdded = cStoreLocal.addItem(cItemLocal, this.m_lTime / 6553L)) != 0) {
                this.m_vCarryItems.removeElement(cItemLocal);
                this.addScore(iAdded * 10);
                this.m_iItemsLevel += iAdded;
                if (iAdded > 3) {
                    ++this.m_iMultiplicatorScore;
                    this.m_lEndScoreMultiplicatorTime = this.m_iMultiplicatorScore == 2 ? this.m_lTime + 655300L : (this.m_lEndScoreMultiplicatorTime += 655300L);
                }
                if (this.m_bySoundMode == 1 || this.m_bySoundMode == 2) {
                    this.m_SndMan.playSound((byte)3, 1);
                }
                while (this.m_iItemsLevel >= this.m_iItemsToDeliverLevel) {
                    this.m_iItemsLevel -= this.m_iItemsToDeliverLevel;
                    if (this.m_iLevel < 20) {
                        ++this.m_iLevel;
                        long lRestTime = (this.m_lLevelEndTime - this.m_lTime) / 65530L;
                        this.addScore(2L * lRestTime);
                        this.initLevel(this.m_iLevel);
                        if (this.m_bySoundMode != 1 && this.m_bySoundMode != 2) continue;
                        this.m_SndMan.playSound((byte)5, 1);
                        continue;
                    }
                    this.addScore(2000L);
                    this.changeIngameMode((byte)6);
                    if (this.m_bySoundMode != 1 && this.m_bySoundMode != 2) continue;
                    this.m_SndMan.playSound((byte)2, 1);
                }
            }
        }
        if (this.m_iBonusPosX == -10) {
            if (this.m_lTime > this.m_lBonusStartTime) {
                this.m_iBonusPosX = this.m_spPlayer.m_nFrameWidth + Math.abs(this.m_random.nextInt()) % (this.m_iBackgroundWidth - 2 * this.m_spPlayer.m_nFrameWidth);
                this.m_iBonusPosY = -10;
            }
        } else if (this.m_iBonusPosY < 164) {
            this.m_iBonusPosY += 4;
            if (Math.abs(this.m_iPlayerPosX - this.m_iBonusPosX) < this.m_spPlayer.m_nFrameWidth / 3 && this.m_iBonusPosY >= this.m_iPlayerPosY && this.m_iBonusPosY < this.m_iPlayerPosY + this.m_spPlayer.m_nFrameHeight) {
                ++this.m_iBonusCatchedCount;
                int nSameColorCount = this.getPlayerGiftsCountByColor(this.m_spBonus.m_nFrameCurrent);
                if (nSameColorCount > 0) {
                    this.addScore(200 * nSameColorCount);
                }
                this.addScore(100 * this.m_iBonusCatchedCount);
                this.getBonusTimeStartRandom();
                this.m_iBonusPosX = -10;
                if (this.m_bySoundMode == 1 || this.m_bySoundMode == 2) {
                    this.m_SndMan.playSound((byte)6, 1);
                }
            }
        } else {
            this.getBonusTimeStartRandom();
            this.m_iBonusPosX = -10;
            this.m_iBonusCatchedCount = 0;
        }
        if (this.m_iMultiplicatorScore > 1 && this.m_iMultiplicatorScore > 1 && this.m_lTime > this.m_lEndScoreMultiplicatorTime) {
            this.m_iMultiplicatorScore = 1;
        }
        if (this.m_vScore.size() != 0 && this.m_lTime - this.m_lStartScoreAddTime > 65530L) {
            this.m_lStartScoreAddTime = this.m_lTime;
            this.m_vScore.removeElementAt(0);
        }
        if (this.m_spPlayer.iX + (this.m_spPlayer.m_nFrameWidth >> 1) > 103) {
            this.m_iBackgroundPosX -= 10;
        }
        if (this.m_spPlayer.iX + (this.m_spPlayer.m_nFrameWidth >> 1) < 73) {
            this.m_iBackgroundPosX += 10;
        }
        if (this.m_iBackgroundPosX > 0) {
            this.m_iBackgroundPosX = 0;
        }
        if (this.m_iBackgroundPosX < -this.m_imBackground.getWidth() + 176) {
            this.m_iBackgroundPosX = -this.m_imBackground.getWidth() + 176;
        }
        if (!this.m_vCarryItems.isEmpty()) {
            int iItemCount = 0;
            e = this.m_vCarryItems.elements();
            while (e.hasMoreElements()) {
                CItem cItemLocal2 = (CItem)e.nextElement();
                cItemLocal2.iX = this.m_iPlayerPosX;
                if (this.m_iPlayerMode == 1) {
                    cItemLocal2.iX -= 18;
                }
                if (this.m_iPlayerMode == 2) {
                    cItemLocal2.iX += 18;
                }
                cItemLocal2.iY = this.m_iPlayerPosY + (this.m_spPlayer.m_nFrameHeight >> 1) - this.m_spItem1.m_nFrameHeight - iItemCount * this.m_spItem1.m_nFrameHeight * 2 / 3;
                ++iItemCount;
            }
        }
        Enumeration e2 = this.m_vItems.elements();
        while (e2.hasMoreElements()) {
            long m_lTimeTemp;
            CItem cItemLocal3 = (CItem)e2.nextElement();
            int nRes = cItemLocal3.update(this.m_lTime);
            if (cItemLocal3.iMode != 1 || (m_lTimeTemp = this.m_lTime - cItemLocal3.m_lStartTime) <= 196590L) continue;
            if (m_lTimeTemp > 327650L) {
                this.m_vItems.removeElement(cItemLocal3);
                this.m_vFreeIDs.addElement(new Integer(cItemLocal3.iID));
                continue;
            }
            long m_lTimeSunk = m_lTimeTemp - 196590L;
            cItemLocal3.iSunk = (int)((long)this.m_spItem1.m_nFrameHeight * m_lTimeSunk / 131060L);
        }
        e = this.m_vDeliverItems.elements();
        while (e.hasMoreElements()) {
            CStore cStoreLocal = (CStore)e.nextElement();
            cStoreLocal.update(this.m_lTime / 6553L);
        }
        if (this.m_lTime - this.m_lLastItemCreateTime > 65530L) {
            if (this.m_vItems.size() < 8) {
                this.createRandomGift();
            }
            this.m_lLastItemCreateTime = this.m_lTime - (long)(Math.abs(this.m_random.nextInt()) % 32765);
        }
        this.m_moFire1.update(iTick);
        this.m_spFire1.m_nFrameCurrent = this.m_moFire1.m_nFrameCurrent;
        this.m_moFire2.update(iTick);
        this.m_spFire2.m_nFrameCurrent = this.m_moFire2.m_nFrameCurrent;
        this.m_moFire3.update(iTick);
        this.m_spFire3.m_nFrameCurrent = this.m_moFire3.m_nFrameCurrent;
        this.m_moFire4.update(iTick);
        this.m_spFire4.m_nFrameCurrent = this.m_moFire4.m_nFrameCurrent;
        this.m_moItem1.update(iTick);
        this.m_spItem1.m_nFrameCurrent = this.m_moItem1.m_nFrameCurrent;
        this.m_moItem2.update(iTick);
        this.m_spItem2.m_nFrameCurrent = this.m_moItem2.m_nFrameCurrent;
        this.m_moItem3.update(iTick);
        this.m_spItem3.m_nFrameCurrent = this.m_moItem3.m_nFrameCurrent;
        this.m_moItem4.update(iTick);
        this.m_spItem4.m_nFrameCurrent = this.m_moItem4.m_nFrameCurrent;
        this.m_moItem5.update(iTick);
        this.m_spItem5.m_nFrameCurrent = this.m_moItem5.m_nFrameCurrent;
    }
}

