/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

class CSoundsManager {
    public static final int SOUND_BEll = 1;
    byte[] m_abySoundsFlag;
    Object[] m_aoSounds;
    int m_byCurrentSoundID;
    byte m_bySoundEnabledFlags;

    public CSoundsManager(byte bySoundEnabledFlags, byte bySoundsMax) {
        this.m_bySoundEnabledFlags = bySoundEnabledFlags;
        this.m_aoSounds = new Object[bySoundsMax];
        this.m_abySoundsFlag = new byte[bySoundsMax];
    }

    public void loadSound(byte bySoundID, String sFilename, String sType, byte bySoundFlag) {
        try {
            this.m_aoSounds[bySoundID] = sFilename;
            InputStream is = null;
            is = this.getClass().getResourceAsStream(sFilename);
            if (is == null) {
                return;
            }
            Player p = Manager.createPlayer((InputStream)is, (String)sType);
            p.realize();
            this.m_aoSounds[bySoundID] = p;
            this.m_abySoundsFlag[bySoundID] = bySoundFlag;
        }
        catch (Exception e) {
        }
    }

    public void playSound(byte bySoundID, int iLoopCount) {
        try {
            if (bySoundID == -1) {
                return;
            }
            if ((this.m_bySoundEnabledFlags & this.m_abySoundsFlag[bySoundID]) != this.m_abySoundsFlag[bySoundID]) {
                return;
            }
            this.stopAllSounds();
            this.m_byCurrentSoundID = bySoundID;
            Player p = (Player)this.m_aoSounds[bySoundID];
            if (p != null) {
                p.prefetch();
                p.setLoopCount(iLoopCount);
                p.start();
            }
        }
        catch (Exception e) {
        }
    }

    public void stopAllSounds() {
        byte i = 0;
        while (i < this.m_aoSounds.length) {
            this.stopSound(i);
            i = (byte)(i + 1);
        }
    }

    public void stopSound(byte bySoundID) {
        if (bySoundID == -1) {
            return;
        }
        try {
            Player p = (Player)this.m_aoSounds[bySoundID];
            if (p != null) {
                p.stop();
                p.deallocate();
                p = null;
            }
        }
        catch (Exception e) {
        }
    }
}

