/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.RecordStore;

public class CRecordHandler {
    byte[] m_byData;
    byte m_byHandleMode = 0;
    int m_iPosition = 0;
    int m_iStoreSize = 450;
    int m_nRecords;
    String m_strRName = "";
    RecordStore recordstore;

    public CRecordHandler(String strRName) {
        this.m_strRName = strRName;
        this.m_byData = new byte[this.m_iStoreSize];
    }

    public int BeginRead() {
        this.m_byHandleMode = 1;
        this.m_iPosition = 0;
        try {
            this.recordstore = RecordStore.openRecordStore((String)this.m_strRName, (boolean)true);
            this.m_nRecords = this.recordstore.getNumRecords();
            if (this.m_nRecords > 0) {
                this.recordstore.getRecord(1, this.m_byData, 0);
            }
        }
        catch (Exception e) {
            return -1;
        }
        return this.m_nRecords;
    }

    public int BeginWrite() {
        this.m_byHandleMode = (byte)2;
        this.m_iPosition = 0;
        try {
            this.recordstore = RecordStore.openRecordStore((String)this.m_strRName, (boolean)true);
            this.m_nRecords = this.recordstore.getNumRecords();
        }
        catch (Exception e) {
            return -1;
        }
        return this.m_nRecords;
    }

    public boolean End() {
        if (this.m_byHandleMode == 2) {
            try {
                if (this.m_nRecords == 0) {
                    this.recordstore.addRecord(this.m_byData, 0, this.m_byData.length);
                } else {
                    this.recordstore.setRecord(1, this.m_byData, 0, this.m_byData.length);
                }
                this.recordstore.closeRecordStore();
            }
            catch (Exception e) {
                return false;
            }
        }
        this.m_byHandleMode = 0;
        return true;
    }

    public byte ReadByte() {
        if (this.m_iPosition >= this.m_iStoreSize) {
            return 0;
        }
        return this.m_byData[this.m_iPosition++];
    }

    public int ReadInt() {
        if (this.m_iPosition >= this.m_iStoreSize) {
            return 0;
        }
        int iRead = 0;
        int iValue = 0;
        int i = 0;
        while (i < 4) {
            iValue = this.m_byData[this.m_iPosition++];
            iRead |= (iValue &= 0xFF) << i * 8;
            ++i;
        }
        return iRead;
    }

    public String ReadString(int iLength) {
        if (this.m_iPosition >= this.m_iStoreSize) {
            return "";
        }
        String strRead = "";
        int i = 0;
        while (i < iLength) {
            strRead = strRead + (char)this.m_byData[this.m_iPosition++];
            ++i;
        }
        return strRead;
    }

    public void WriteByte(byte byData) {
        if (this.m_iPosition >= this.m_iStoreSize) {
            return;
        }
        this.m_byData[this.m_iPosition++] = byData;
    }

    public void WriteInt(int iData) {
        if (this.m_iPosition >= this.m_iStoreSize) {
            return;
        }
        int i = 0;
        while (i < 4) {
            this.m_byData[this.m_iPosition++] = (byte)(iData >> i * 8 & 0xFF);
            ++i;
        }
    }

    public void WriteString(String strData) {
        if (this.m_iPosition >= this.m_iStoreSize) {
            return;
        }
        int i = 0;
        while (i < strData.length()) {
            this.m_byData[this.m_iPosition++] = (byte)strData.charAt(i);
            ++i;
        }
    }

    public void WriteStringForceLength(String strData, int iClampSize) {
        if (this.m_iPosition >= this.m_iStoreSize) {
            return;
        }
        if (iClampSize > strData.length()) {
            int iCA = iClampSize - strData.length();
            int i = 0;
            while (i < iCA) {
                strData = strData + ' ';
                ++i;
            }
        } else if (strData.length() > iClampSize) {
            strData = strData.substring(0, iClampSize);
        }
        this.WriteString(strData);
    }
}

