/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CHighscore {
    static final byte SCROLL_DOWN = 1;
    static final byte SCROLL_UP = 0;
    int countTo;
    String[] m_aStrNames;
    int[] m_anColumnOffset;
    boolean m_bDrawPlaces;
    Font m_fFont;
    GameCanvas m_gc;
    int m_nClipH;
    int m_nClipW;
    int m_nClipX;
    int m_nClipY;
    int m_nColorFont = 7380478;
    int m_nColorNew = 16646401;
    int m_nGlobalCounter;
    int m_nIndex;
    int m_nLength;
    int m_nMaxEntries;
    int m_nMaxNameLength;
    int m_nPosYscrollBar;
    int m_nRowsOffset;
    int[] m_nScores;
    int m_nTableOffset;
    int[] temp;
    String[] tempArray;

    public CHighscore(GameCanvas parent, int nNumberOfHighScoreEntries, int nMaximumNameLength, Font fTheFont, byte byDrawPlaces) {
        this.m_gc = parent;
        this.m_nMaxEntries = nNumberOfHighScoreEntries;
        this.m_nMaxNameLength = nMaximumNameLength;
        this.m_fFont = fTheFont;
        this.m_bDrawPlaces = byDrawPlaces != -1;
    }

    final boolean addHighscore(String Name, int Score) {
        if (this.m_nLength == 0) {
            this.m_aStrNames = new String[1];
            this.m_aStrNames[0] = Name;
            this.m_nScores = new int[1];
            this.m_nScores[0] = Score;
            ++this.m_nLength;
            return true;
        }
        try {
            if (this.m_nLength < this.m_nMaxEntries) {
                this.temp = new int[this.m_nLength];
                System.arraycopy(this.m_nScores, 0, this.temp, 0, this.m_nScores.length);
                this.m_nScores = new int[this.temp.length + 1];
                System.arraycopy(this.temp, 0, this.m_nScores, 0, this.temp.length);
                this.tempArray = new String[this.m_nLength];
                System.arraycopy(this.m_aStrNames, 0, this.tempArray, 0, this.m_aStrNames.length);
                this.m_aStrNames = new String[this.tempArray.length + 1];
                System.arraycopy(this.tempArray, 0, this.m_aStrNames, 0, this.tempArray.length);
            }
            int i = 0;
            while (i < this.m_nScores.length) {
                if (Score > this.m_nScores[i]) break;
                ++i;
            }
            if (i > this.m_nLength) {
                return false;
            }
            int j = this.m_nScores.length - 1;
            while (j > i) {
                this.m_aStrNames[j] = this.m_aStrNames[j - 1];
                this.m_nScores[j] = this.m_nScores[j - 1];
                --j;
            }
            this.m_aStrNames[i] = Name;
            this.m_nScores[i] = Score;
            this.m_nLength = this.m_nLength + 1 > this.m_nMaxEntries ? this.m_nMaxEntries : this.m_nLength + 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    final void draw(Graphics g, int iHighlight) {
        g.setColor(this.m_nColorFont);
        g.setClip(this.m_nClipX, 5, this.m_nClipW, 16);
        this.m_gc.drawMyString1(g, "-" + this.m_gc.m_astrLang[3] + "-", 88, 5, 17);
        g.setClip(this.m_nClipX, this.m_nClipY, this.m_nClipW, this.m_nClipH);
        this.m_nTableOffset = 0;
        if (this.m_bDrawPlaces) {
            this.m_gc.drawMyString1(g, "#", this.m_anColumnOffset[0], this.m_nClipY + this.m_nTableOffset, 20);
        }
        this.m_gc.drawMyString1(g, this.m_gc.m_astrLang[16], this.m_anColumnOffset[1], this.m_nClipY + this.m_nTableOffset, 20);
        this.m_gc.drawMyString1(g, this.m_gc.m_astrLang[17], this.m_anColumnOffset[2], this.m_nClipY + this.m_nTableOffset, 20);
        this.m_nTableOffset += 16;
        g.drawLine(this.m_nClipX, this.m_nClipY + this.m_nTableOffset + 0, this.m_nClipX + this.m_nClipW, this.m_nClipY + this.m_nTableOffset + 0);
        this.m_nTableOffset += 2;
        if (this.m_aStrNames == null || this.m_aStrNames.length == 0) {
            this.m_gc.drawMyString1(g, "----------", this.m_nClipX + (this.m_nClipW >> 1), this.m_nClipY + this.m_nTableOffset + 10, 17);
        } else {
            this.countTo = (this.m_nClipH - this.m_nTableOffset) / 16 > this.m_nScores.length ? this.m_nScores.length : (this.m_nClipH - this.m_nTableOffset) / 16;
            this.m_nGlobalCounter = 0;
            while (this.m_nGlobalCounter < this.countTo) {
                if (this.m_nGlobalCounter + this.m_nIndex == iHighlight) {
                    g.setColor(this.m_nColorNew);
                } else {
                    g.setColor(this.m_nColorFont);
                    this.m_nRowsOffset = 16 * this.m_nGlobalCounter + 1;
                    if (this.m_bDrawPlaces) {
                        this.m_gc.drawMyString1(g, "" + (1 + this.m_nGlobalCounter + this.m_nIndex), this.m_anColumnOffset[0], this.m_nClipY + this.m_nTableOffset + this.m_nRowsOffset, 20);
                    }
                    this.m_gc.drawMyString1(g, this.m_aStrNames[this.m_nGlobalCounter + this.m_nIndex], this.m_anColumnOffset[1], this.m_nClipY + this.m_nTableOffset + this.m_nRowsOffset, 20);
                    this.m_gc.drawMyString1(g, "" + this.m_nScores[this.m_nGlobalCounter + this.m_nIndex], this.m_anColumnOffset[2], this.m_nClipY + this.m_nTableOffset + this.m_nRowsOffset, 20);
                    g.setColor(this.m_nColorFont);
                }
                ++this.m_nGlobalCounter;
            }
            if (this.countTo < this.m_nScores.length) {
                int iBarHeight = Math.max(3, (16 * this.countTo + 0) / (this.m_nScores.length - this.countTo + 1));
                int iBarY = this.m_nClipY + this.m_nTableOffset + this.m_nIndex * iBarHeight;
                g.fillRect(this.m_nClipX + this.m_nClipW - 5, iBarY, 4, iBarHeight);
                g.drawRect(this.m_nClipX + this.m_nClipW - 5, this.m_nClipY + this.m_nTableOffset, 4, iBarHeight * (this.m_nScores.length - this.countTo + 1));
            }
        }
    }

    final int isScoreInHighscore(int score) {
        if (score <= 0) {
            return -1;
        }
        if (this.m_nLength <= 0) {
            return 1;
        }
        if (this.m_nLength + 1 < this.m_nMaxEntries) {
            return 1;
        }
        int i = 0;
        while (i < this.m_nScores.length) {
            if (this.m_nScores[i] < score) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    final void keyPressed(int keyCode) {
        if (this.m_aStrNames == null || this.m_aStrNames.length <= 1) {
            return;
        }
        if ((this.m_nClipH - this.m_nTableOffset) / 16 > this.m_nScores.length) {
            this.m_nIndex = 0;
            return;
        }
        if (keyCode == 1) {
            ++this.m_nIndex;
            if (this.m_nIndex + (this.m_nClipH - this.m_nTableOffset) / 16 > this.m_nScores.length) {
                this.m_nIndex = this.m_nScores.length - (this.m_nClipH - this.m_nTableOffset) / 16;
            }
        } else {
            --this.m_nIndex;
            if (this.m_nIndex < 0) {
                this.m_nIndex = 0;
            }
        }
    }

    final void loadHighscoreFromRecord(CRecordHandler CRH) {
        this.m_nLength = CRH.ReadInt();
        if (this.m_nLength == 0) {
            return;
        }
        this.m_aStrNames = new String[this.m_nLength];
        this.m_nScores = new int[this.m_nLength];
        int i = 0;
        while (i < this.m_nLength) {
            this.m_aStrNames[i] = new String(CRH.ReadString(this.m_nMaxNameLength).trim());
            try {
                this.m_nScores[i] = CRH.ReadInt();
            }
            catch (Exception ex) {
                System.out.println("" + ex.getMessage() + "   " + ex.toString());
                ex.printStackTrace();
            }
            ++i;
        }
    }

    final void saveHighscoreToRecord(CRecordHandler CRH) {
        CRH.WriteInt(this.m_nLength);
        int i = 0;
        while (i < this.m_nLength) {
            CRH.WriteStringForceLength(this.m_aStrNames[i], this.m_nMaxNameLength);
            CRH.WriteInt(this.m_nScores[i]);
            ++i;
        }
    }

    final void setClipRect(int x, int y, int w, int h) {
        this.m_nClipX = x;
        this.m_nClipY = y;
        this.m_nClipW = w;
        this.m_nClipH = h;
    }

    final void setColumnOffset(int[] anColumnOffset) {
        this.m_anColumnOffset = new int[anColumnOffset.length];
        System.arraycopy(anColumnOffset, 0, this.m_anColumnOffset, 0, anColumnOffset.length);
    }
}

