/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CBitmapFont {
    char[] m_acCharIndex = new char[384];
    char[] m_anTileData;
    byte m_bySpaceWidth = 1;
    char m_cCharCount;
    int m_iHeight;
    Image m_imTiles = null;
    String m_strValidChars;

    public CBitmapFont(Image imTiles, DataInputStream diTileData, String strValidChars, byte bySpaceWidth) {
        this.LoadTileData(imTiles, diTileData, strValidChars, bySpaceWidth);
    }

    public CBitmapFont(Image imTiles, String strTileDataFile, String strValidChars, byte bySpaceWidth) {
        try {
            this.LoadTileData(imTiles, new DataInputStream(this.getClass().getResourceAsStream(strTileDataFile)), strValidChars, bySpaceWidth);
        }
        catch (Exception e) {
            // empty catch block
        }
        System.gc();
    }

    public void LoadTileData(Image imTiles, DataInputStream diTileData, String strValidChars, byte bySpaceWidth) {
        this.m_imTiles = imTiles;
        this.m_anTileData = null;
        System.gc();
        try {
            char iTemp = this.m_cCharCount = (char)diTileData.read();
            this.m_anTileData = new char[this.m_cCharCount * 4];
            int i = 0;
            while (i < this.m_cCharCount * 4) {
                this.m_anTileData[i] = (char)diTileData.read();
                ++i;
            }
            this.m_iHeight = this.m_anTileData[3];
        }
        catch (IOException e) {
            return;
        }
        this.m_imTiles = imTiles;
        this.m_strValidChars = strValidChars;
        this.m_bySpaceWidth = bySpaceWidth;
        this.createCharArray();
        System.gc();
    }

    public void createCharArray() {
        int i = 0;
        while (i < this.m_strValidChars.length()) {
            char c = this.m_strValidChars.charAt(i);
            this.m_acCharIndex[c] = i;
            i = (char)(i + 1);
        }
    }

    public void drawString(Graphics g, String strText, int x, int y, int iManipulation, int iSpacing) {
        int nClX = g.getClipX();
        int nClY = g.getClipY();
        int nClW = g.getClipWidth();
        int nClH = g.getClipHeight();
        int nClX2 = nClX + nClW;
        int nClY2 = nClY + nClH;
        boolean bDraw = false;
        if ((iManipulation & 8) == 8) {
            x -= this.getStringWidth(strText, iSpacing);
        }
        if ((iManipulation & 1) == 1) {
            x -= this.getStringWidth(strText, iSpacing) >> 1;
        }
        if ((iManipulation & 2) == 2) {
            y -= this.getHeight() >> 1;
        }
        if ((iManipulation & 0x20) == 32) {
            y -= this.getHeight();
        }
        int i = 0;
        while (i < strText.length()) {
            int c = strText.charAt(i);
            if (c < 0 || c > 383) {
                c = 63;
            }
            if (c == 32) {
                x += this.m_bySpaceWidth;
            } else {
                char cID = this.m_acCharIndex[c];
                int w = this.m_anTileData[(cID << 2) + 2];
                int h = this.m_anTileData[(cID << 2) + 3];
                int x2 = x + w;
                int y2 = y + h;
                if (x2 > nClX && x < nClX2 && y2 > nClY && y < nClY2) {
                    bDraw = true;
                    int cx = x;
                    int cy = y;
                    int cw = w;
                    int ch = h;
                    if (x < nClX) {
                        cw -= nClX - x;
                        cx = nClX;
                    }
                    if (y < nClY) {
                        ch -= nClY - y;
                        cy = nClY;
                    }
                    if (nClX2 < x2) {
                        cw = nClX2 - x;
                    }
                    if (nClY2 < y2) {
                        ch = nClY2 - y;
                    }
                    if (cw < 0) {
                        cw = 0;
                    }
                    if (ch < 0) {
                        ch = 0;
                    }
                    g.setClip(cx, cy, cw, ch);
                    g.drawImage(this.m_imTiles, x - this.m_anTileData[cID << 2], y - this.m_anTileData[(cID << 2) + 1], 20);
                }
                x += w + iSpacing;
            }
            ++i;
        }
        if (bDraw) {
            g.setClip(nClX, nClY, nClW, nClH);
        }
    }

    public int getHeight() {
        return this.m_iHeight;
    }

    public byte getHeight(byte byID) {
        return (byte)this.m_anTileData[(byID << 2) + 3];
    }

    public int getStringWidth(String strText, int iSpacing) {
        int iWidth = 0;
        int i = 0;
        while (i < strText.length()) {
            int c = strText.charAt(i);
            if (c < 0 || c > 383) {
                c = 63;
            }
            if (c == 32) {
                iWidth += this.m_bySpaceWidth;
            } else {
                char cID = this.m_acCharIndex[c];
                iWidth += this.m_anTileData[(cID << 2) + 2] + iSpacing;
            }
            ++i;
        }
        return iWidth;
    }

    public byte getWidth(byte byID) {
        return (byte)this.m_anTileData[(byID << 2) + 2];
    }
}

